/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.soteria.cdi;

import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.security.enterprise.CallerPrincipal;
import javax.security.enterprise.credential.Credential;
import javax.security.enterprise.identitystore.CredentialValidationResult;
import javax.security.enterprise.identitystore.IdentityStore;
import javax.security.enterprise.identitystore.IdentityStoreHandler;
import org.glassfish.soteria.cdi.CdiUtils;

public class DefaultIdentityStoreHandler
implements IdentityStoreHandler {
    private List<IdentityStore> authenticationIdentityStores;
    private List<IdentityStore> authorizationIdentityStores;

    public void init() {
        List<IdentityStore> identityStores = CdiUtils.getBeanReferencesByType(IdentityStore.class, false);
        this.authenticationIdentityStores = identityStores.stream().filter(i -> i.validationTypes().contains(IdentityStore.ValidationType.VALIDATE)).sorted(Comparator.comparing(IdentityStore::priority)).collect(Collectors.toList());
        this.authorizationIdentityStores = identityStores.stream().filter(i -> i.validationTypes().contains(IdentityStore.ValidationType.PROVIDE_GROUPS) && !i.validationTypes().contains(IdentityStore.ValidationType.VALIDATE)).sorted(Comparator.comparing(IdentityStore::priority)).collect(Collectors.toList());
    }

    public CredentialValidationResult validate(Credential credential) {
        CredentialValidationResult validationResult = null;
        IdentityStore identityStore = null;
        for (IdentityStore authenticationIdentityStore : this.authenticationIdentityStores) {
            validationResult = authenticationIdentityStore.validate(credential);
            if (validationResult.getStatus() != CredentialValidationResult.Status.VALID) continue;
            identityStore = authenticationIdentityStore;
            break;
        }
        if (validationResult == null) {
            return CredentialValidationResult.INVALID_RESULT;
        }
        if (validationResult.getStatus() != CredentialValidationResult.Status.VALID) {
            return validationResult;
        }
        CallerPrincipal callerPrincipal = validationResult.getCallerPrincipal();
        HashSet groups = new HashSet();
        if (identityStore.validationTypes().contains(IdentityStore.ValidationType.PROVIDE_GROUPS)) {
            groups.addAll(validationResult.getCallerGroups());
        }
        for (IdentityStore authorizationIdentityStore : this.authorizationIdentityStores) {
            groups.addAll(authorizationIdentityStore.getCallerGroups(validationResult));
        }
        return new CredentialValidationResult(callerPrincipal, groups);
    }
}

