/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.soteria.identitystores;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.security.enterprise.CallerPrincipal;
import javax.security.enterprise.credential.Credential;
import javax.security.enterprise.credential.UsernamePasswordCredential;
import javax.security.enterprise.identitystore.CredentialValidationResult;
import javax.security.enterprise.identitystore.DataBaseIdentityStoreDefinition;
import javax.security.enterprise.identitystore.IdentityStore;
import javax.sql.DataSource;
import org.glassfish.soteria.cdi.CdiUtils;

public class DataBaseIdentityStore
implements IdentityStore {
    private final DataBaseIdentityStoreDefinition dataBaseIdentityStoreDefinition;
    private final Set<IdentityStore.ValidationType> validationTypes;

    public DataBaseIdentityStore(DataBaseIdentityStoreDefinition dataBaseIdentityStoreDefinition) {
        this.dataBaseIdentityStoreDefinition = dataBaseIdentityStoreDefinition;
        this.validationTypes = Collections.unmodifiableSet(new HashSet<IdentityStore.ValidationType>(Arrays.asList(dataBaseIdentityStoreDefinition.useFor())));
    }

    public CredentialValidationResult validate(Credential credential) {
        if (credential instanceof UsernamePasswordCredential) {
            return this.validate((UsernamePasswordCredential)credential);
        }
        return CredentialValidationResult.NOT_VALIDATED_RESULT;
    }

    public CredentialValidationResult validate(UsernamePasswordCredential usernamePasswordCredential) {
        DataSource dataSource = (DataSource)CdiUtils.jndiLookup(this.dataBaseIdentityStoreDefinition.dataSourceLookup());
        List<String> passwords = this.executeQuery(dataSource, this.dataBaseIdentityStoreDefinition.callerQuery(), usernamePasswordCredential.getCaller());
        if (!passwords.isEmpty() && usernamePasswordCredential.getPassword().compareTo(passwords.get(0))) {
            return new CredentialValidationResult(new CallerPrincipal(usernamePasswordCredential.getCaller()), new HashSet<String>(this.executeQuery(dataSource, this.dataBaseIdentityStoreDefinition.groupsQuery(), usernamePasswordCredential.getCaller())));
        }
        return CredentialValidationResult.INVALID_RESULT;
    }

    public Set<String> getCallerGroups(CredentialValidationResult validationResult) {
        DataSource dataSource = (DataSource)CdiUtils.jndiLookup(this.dataBaseIdentityStoreDefinition.dataSourceLookup());
        return new HashSet<String>(this.executeQuery(dataSource, this.dataBaseIdentityStoreDefinition.groupsQuery(), validationResult.getCallerPrincipal().getName()));
    }

    private List<String> executeQuery(DataSource dataSource, String query, String parameter) {
        ArrayList<String> result = new ArrayList<String>();
        try (Connection connection = dataSource.getConnection();
             PreparedStatement statement = connection.prepareStatement(query);){
            statement.setString(1, parameter);
            try (ResultSet resultSet = statement.executeQuery();){
                while (resultSet.next()) {
                    result.add(resultSet.getString(1));
                }
            }
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
        return result;
    }

    public int priority() {
        return this.dataBaseIdentityStoreDefinition.priority();
    }

    public Set<IdentityStore.ValidationType> validationTypes() {
        return this.validationTypes;
    }
}

