/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.soteria.identitystores;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import javax.naming.AuthenticationException;
import javax.naming.NamingException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.security.enterprise.CallerPrincipal;
import javax.security.enterprise.credential.Credential;
import javax.security.enterprise.credential.UsernamePasswordCredential;
import javax.security.enterprise.identitystore.CredentialValidationResult;
import javax.security.enterprise.identitystore.IdentityStore;
import javax.security.enterprise.identitystore.LdapIdentityStoreDefinition;

public class LdapIdentityStore
implements IdentityStore {
    private final LdapIdentityStoreDefinition ldapIdentityStoreDefinition;
    private final Set<IdentityStore.ValidationType> validationTypes;

    public LdapIdentityStore(LdapIdentityStoreDefinition ldapIdentityStoreDefinition) {
        this.ldapIdentityStoreDefinition = ldapIdentityStoreDefinition;
        this.validationTypes = Collections.unmodifiableSet(new HashSet<IdentityStore.ValidationType>(Arrays.asList(ldapIdentityStoreDefinition.useFor())));
    }

    public CredentialValidationResult validate(Credential credential) {
        if (credential instanceof UsernamePasswordCredential) {
            return this.validate((UsernamePasswordCredential)credential);
        }
        return CredentialValidationResult.NOT_VALIDATED_RESULT;
    }

    public CredentialValidationResult validate(UsernamePasswordCredential usernamePasswordCredential) {
        if (this.ldapIdentityStoreDefinition.baseDn().isEmpty()) {
            return this.checkDirectBinding(usernamePasswordCredential);
        }
        return this.checkThroughSearch(usernamePasswordCredential);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getCallerGroups(CredentialValidationResult validationResult) {
        LdapContext ldapContext = LdapIdentityStore.createLdapContext(this.ldapIdentityStoreDefinition.url(), this.ldapIdentityStoreDefinition.baseDn(), this.ldapIdentityStoreDefinition.password());
        if (ldapContext != null) {
            try {
                HashSet<String> hashSet = new HashSet<String>(this.retrieveGroupInformation(validationResult.getCallerPrincipal().getName(), ldapContext));
                return hashSet;
            }
            finally {
                this.closeContext(ldapContext);
            }
        }
        return Collections.emptySet();
    }

    private CredentialValidationResult checkThroughSearch(UsernamePasswordCredential usernamePasswordCredential) {
        LdapContext ldapContext = LdapIdentityStore.createLdapContext(this.ldapIdentityStoreDefinition.url(), this.ldapIdentityStoreDefinition.baseDn(), this.ldapIdentityStoreDefinition.password());
        if (ldapContext != null) {
            String callerDn = this.searchCaller(ldapContext, this.ldapIdentityStoreDefinition.searchBase(), String.format(this.ldapIdentityStoreDefinition.searchExpression(), usernamePasswordCredential.getCaller()));
            LdapContext ldapContextCaller = null;
            if (callerDn != null) {
                ldapContextCaller = LdapIdentityStore.createLdapContext(this.ldapIdentityStoreDefinition.url(), callerDn, new String(usernamePasswordCredential.getPassword().getValue()));
            }
            if (ldapContextCaller == null) {
                this.closeContext(ldapContext);
                return CredentialValidationResult.INVALID_RESULT;
            }
            Set<String> groups = this.retrieveGroupInformation(callerDn, ldapContext);
            this.closeContext(ldapContext);
            return new CredentialValidationResult(new CallerPrincipal(usernamePasswordCredential.getCaller()), groups);
        }
        return CredentialValidationResult.INVALID_RESULT;
    }

    private String searchCaller(LdapContext ldapContext, String searchBase, String searchExpression) {
        String result = null;
        List<SearchResult> callerDn = LdapIdentityStore.search(ldapContext, searchBase, searchExpression);
        if (callerDn.size() > 1) {
            // empty if block
        }
        if (callerDn.size() == 1) {
            result = callerDn.get(0).getNameInNamespace();
        }
        return result;
    }

    private CredentialValidationResult checkDirectBinding(UsernamePasswordCredential usernamePasswordCredential) {
        String callerDn = LdapIdentityStore.createCallerDn(this.ldapIdentityStoreDefinition.callerNameAttribute(), usernamePasswordCredential.getCaller(), this.ldapIdentityStoreDefinition.callerBaseDn());
        LdapContext ldapContext = LdapIdentityStore.createLdapContext(this.ldapIdentityStoreDefinition.url(), callerDn, new String(usernamePasswordCredential.getPassword().getValue()));
        if (ldapContext == null) {
            return CredentialValidationResult.INVALID_RESULT;
        }
        Set<String> groups = this.retrieveGroupInformation(callerDn, ldapContext);
        this.closeContext(ldapContext);
        return new CredentialValidationResult(new CallerPrincipal(usernamePasswordCredential.getCaller()), groups);
    }

    private void closeContext(LdapContext ldapContext) {
        try {
            ldapContext.close();
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    private Set<String> retrieveGroupInformation(String callerDn, LdapContext ldapContext) {
        List<SearchResult> searchResults = LdapIdentityStore.search(ldapContext, this.ldapIdentityStoreDefinition.groupBaseDn(), this.ldapIdentityStoreDefinition.groupCallerDnAttribute(), callerDn, this.ldapIdentityStoreDefinition.groupNameAttribute());
        HashSet<String> groups = new HashSet<String>();
        for (SearchResult searchResult : searchResults) {
            for (Object group : LdapIdentityStore.get(searchResult, this.ldapIdentityStoreDefinition.groupNameAttribute())) {
                groups.add(group.toString());
            }
        }
        return groups;
    }

    private static String createCallerDn(String callerNameAttribute, String callerName, String callerBaseDn) {
        return String.format("%s=%s,%s", callerNameAttribute, callerName, callerBaseDn);
    }

    private static LdapContext createLdapContext(String url, String bindDn, String bindCredential) {
        try {
            return new InitialLdapContext(LdapIdentityStore.getConnectionEnvironment(url, bindDn, bindCredential), null);
        }
        catch (AuthenticationException e) {
            return null;
        }
        catch (NamingException e) {
            throw new IllegalStateException(e);
        }
    }

    private static Hashtable<String, String> getConnectionEnvironment(String url, String bindDn, String bindCredential) {
        Hashtable<String, String> environment = new Hashtable<String, String>();
        environment.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        environment.put("java.naming.provider.url", url);
        environment.put("java.naming.security.authentication", "simple");
        environment.put("java.naming.security.principal", bindDn);
        environment.put("java.naming.security.credentials", bindCredential);
        return environment;
    }

    private static List<SearchResult> search(LdapContext ldapContext, String searchBase, String filterAttribute, String filterValue, String returnAttribute) {
        SearchControls controls = new SearchControls();
        controls.setReturningAttributes(new String[]{returnAttribute});
        try {
            return Collections.list(ldapContext.search(searchBase, String.format("(%s={0})", filterAttribute), new Object[]{filterValue}, controls));
        }
        catch (NamingException e) {
            throw new IllegalStateException(e);
        }
    }

    private static List<SearchResult> search(LdapContext ldapContext, String searchBase, String searchExpression) {
        SearchControls controls = new SearchControls();
        controls.setSearchScope(2);
        try {
            return Collections.list(ldapContext.search(searchBase, searchExpression, controls));
        }
        catch (NamingException e) {
            throw new IllegalStateException(e);
        }
    }

    private static List<?> get(SearchResult searchResult, String attributeName) {
        try {
            return Collections.list(searchResult.getAttributes().get(attributeName).getAll());
        }
        catch (NamingException e) {
            throw new IllegalStateException(e);
        }
    }

    public int priority() {
        return this.ldapIdentityStoreDefinition.priority();
    }

    public Set<IdentityStore.ValidationType> validationTypes() {
        return this.validationTypes;
    }
}

