/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.soteria.mechanisms;

import java.lang.annotation.Annotation;
import javax.enterprise.inject.spi.CDI;
import javax.security.auth.message.AuthException;
import javax.security.enterprise.AuthenticationStatus;
import javax.security.enterprise.authentication.mechanism.http.HttpAuthenticationMechanism;
import javax.security.enterprise.authentication.mechanism.http.HttpMessageContext;
import javax.security.enterprise.credential.Credential;
import javax.security.enterprise.credential.Password;
import javax.security.enterprise.credential.UsernamePasswordCredential;
import javax.security.enterprise.identitystore.CredentialValidationResult;
import javax.security.enterprise.identitystore.IdentityStoreHandler;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.DatatypeConverter;
import org.glassfish.soteria.Utils;

public class BasicAuthenticationMechanism
implements HttpAuthenticationMechanism {
    private String basicHeaderValue;

    public BasicAuthenticationMechanism() {
    }

    public BasicAuthenticationMechanism(String realmName) {
        this.basicHeaderValue = String.format("Basic realm=\"%s\"", realmName);
    }

    public AuthenticationStatus validateRequest(HttpServletRequest request, HttpServletResponse response, HttpMessageContext httpMsgContext) throws AuthException {
        IdentityStoreHandler identityStoreHandler;
        CredentialValidationResult result;
        Object[] credentials = this.getCredentials(request);
        if (!Utils.isEmpty(credentials) && (result = (identityStoreHandler = (IdentityStoreHandler)CDI.current().select(IdentityStoreHandler.class, new Annotation[0]).get()).validate((Credential)new UsernamePasswordCredential((String)credentials[0], new Password((String)credentials[1])))).getStatus() == CredentialValidationResult.Status.VALID) {
            return httpMsgContext.notifyContainerAboutLogin(result.getCallerPrincipal(), result.getCallerGroups());
        }
        if (httpMsgContext.isProtected()) {
            response.setHeader("WWW-Authenticate", this.basicHeaderValue);
            return httpMsgContext.responseUnAuthorized();
        }
        return httpMsgContext.doNothing();
    }

    private String[] getCredentials(HttpServletRequest request) {
        String authorizationHeader = request.getHeader("Authorization");
        if (!Utils.isEmpty(authorizationHeader) && authorizationHeader.startsWith("Basic ")) {
            return new String(DatatypeConverter.parseBase64Binary((String)authorizationHeader.substring(6))).split(":");
        }
        return null;
    }
}

