/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.core.virtual;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import org.glassfish.tyrus.core.virtual.LoomishExecutors;

public final class VirtualThreadSupport {
    private VirtualThreadSupport() {
        throw new IllegalStateException();
    }

    public static boolean isVirtualThread() {
        return false;
    }

    public static LoomishExecutors allowVirtual(boolean allow, ThreadFactory threadFactory) {
        return new NonLoomishExecutors(threadFactory);
    }

    private static final class NonLoomishExecutors
    implements LoomishExecutors {
        private final ThreadFactory threadFactory;

        private NonLoomishExecutors(ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
        }

        @Override
        public ExecutorService newCachedThreadPool() {
            return Executors.newCachedThreadPool(this.threadFactory);
        }

        @Override
        public ExecutorService newFixedThreadPool(int nThreads) {
            return Executors.newFixedThreadPool(nThreads, this.threadFactory);
        }

        @Override
        public ScheduledExecutorService getScheduledExecutorService(int nThreads) {
            return Executors.newScheduledThreadPool(nThreads, this.threadFactory);
        }

        @Override
        public ThreadFactory getThreadFactory() {
            return this.threadFactory;
        }

        @Override
        public Thread newThread(String name, Runnable runnable) {
            return new Thread(null, runnable, name, 0L);
        }

        @Override
        public boolean isVirtual() {
            return false;
        }
    }
}

