/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.utils;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.utils.JdkVersion;

public class DataStructures {
    private static final Class<?> LTQclass;

    private static Class<?> getAndVerify(String cname) throws Throwable {
        return DataStructures.class.getClassLoader().loadClass(cname).newInstance().getClass();
    }

    public static <T> BlockingQueue<T> getLTQInstance() {
        try {
            return (BlockingQueue)LTQclass.newInstance();
        }
        catch (Exception ea) {
            throw new RuntimeException(ea);
        }
    }

    public static <T> BlockingQueue<T> getLTQInstance(Class<T> t) {
        try {
            return (BlockingQueue)LTQclass.newInstance();
        }
        catch (Exception ea) {
            throw new RuntimeException(ea);
        }
    }

    static {
        Class<Object> c;
        String className = null;
        try {
            JdkVersion jdkVersion = JdkVersion.getJdkVersion();
            JdkVersion minimumVersion = JdkVersion.parseVersion("1.7.0");
            className = minimumVersion.compareTo(jdkVersion) <= 0 ? "java.util.concurrent.LinkedTransferQueue" : "maskedclasses.LinkedTransferQueue";
            c = DataStructures.getAndVerify(className);
            Grizzly.logger(DataStructures.class).log(Level.FINE, "USING LTQ class:{0}", c);
        }
        catch (Throwable t) {
            Grizzly.logger(DataStructures.class).log(Level.FINE, "failed loading datastructure class:" + className + " fallback to embedded one", t);
            c = LinkedBlockingQueue.class;
        }
        LTQclass = c;
    }
}

