/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.core;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.glassfish.tyrus.spi.SPIRemoteEndpoint;

public class OutputStreamToAsyncBinaryAdapter
extends OutputStream {
    private final SPIRemoteEndpoint re;

    public OutputStreamToAsyncBinaryAdapter(SPIRemoteEndpoint re) {
        this.re = re;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        ByteBuffer result = ByteBuffer.allocate(len);
        result.put(Arrays.copyOfRange(b, off, len));
        this.re.sendBinary(result, false);
    }

    @Override
    public void write(int i) throws IOException {
        this.re.sendBinary(ByteBuffer.wrap(new byte[]{(byte)i}), false);
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
        this.re.sendBinary(ByteBuffer.wrap(new byte[0]), true);
    }
}

