/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.ext.client.cli;

import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import javax.websocket.CloseReason;
import javax.websocket.DeploymentException;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.PongMessage;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;
import jline.TerminalFactory;
import jline.console.ConsoleReader;
import jline.console.CursorBuffer;
import jline.console.completer.StringsCompleter;
import org.glassfish.tyrus.client.ClientManager;

public class ClientCli {
    public static final String NAME = "tyrus-client";
    public static final String CONSOLE_PREFIX_NO_CONN = "tyrus-client> ";
    public static final String CONSOLE_PREFIX_CONN = "session %s> ";
    private static volatile Session session = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException, DeploymentException, InterruptedException {
        block37: {
            ClientManager clientManager = new ClientManager();
            try {
                String line;
                ConsoleReader console = new ConsoleReader(NAME, new FileInputStream(FileDescriptor.in), System.out, null);
                console.addCompleter(new StringsCompleter("open", "close", "send", "ping", "exit", "quit", "help"));
                console.setPrompt(ClientCli.getPrompt());
                if (args.length > 0) {
                    int i = 0;
                    while (i < args.length && args[i].startsWith("--")) {
                        String arg;
                        if ((arg = args[i++]).equals("--proxy")) {
                            if (i < args.length) {
                                String proxyUrl = args[i++];
                                clientManager.getProperties().put("org.glassfish.tyrus.client.proxy", proxyUrl);
                            } else {
                                ClientCli.print(console, null, String.format("--proxy requires an argument (url)", new Object[0]), false);
                            }
                        }
                        if (!arg.equals("--help")) continue;
                        String help = "\n\nUsage: cmd [--proxy proxyUrl] [ws uri]\n\nruntime commands:\n\topen uri : open a connection to the web socket uri\n\tclose : close a currently open web socket session\n\tsend message : send a text message\n\tsend : send a multiline text message teminated with a .\n\tping : send a ping message\n\tquit | exit : exit this tool\n\thelp : display this message";
                        ClientCli.print(console, null, help, false);
                        return;
                    }
                    if (i == args.length - 1) {
                        ClientCli.connectToURI(console, args[i], clientManager);
                        console.getHistory().add("open " + args[i]);
                        console.setPrompt(ClientCli.getPrompt());
                        ++i;
                    }
                    if (i != args.length) {
                        ClientCli.print(console, null, String.format("Invalid argument count, usage cmd [--proxy proxyUrl] [ws uri]", new Object[0]), false);
                        return;
                    }
                }
                while ((line = console.readLine()) != null) {
                    block36: {
                        try {
                            line = line.trim();
                            if (line.length() == 0) break block36;
                            if (line.startsWith("open ")) {
                                String uri = line.substring(5).trim();
                                ClientCli.connectToURI(console, uri, clientManager);
                                break block36;
                            }
                            if (line.startsWith("close")) {
                                if (session != null) {
                                    session.close();
                                }
                                session = null;
                                ClientCli.print(console, null, String.format("Session closed", new Object[0]), false);
                                break block36;
                            }
                            if (line.startsWith("send ")) {
                                String message = line.substring(5);
                                if (session != null) {
                                    session.getBasicRemote().sendText(message);
                                }
                                break block36;
                            }
                            if (line.startsWith("send")) {
                                String subLine;
                                ClientCli.print(console, null, String.format("End multiline message with . on own line", new Object[0]), false);
                                String temporaryPrompt = "send...> ";
                                console.setPrompt(temporaryPrompt);
                                StringBuilder sb = new StringBuilder();
                                while (!".".equals(subLine = console.readLine())) {
                                    sb.append(subLine);
                                    sb.append('\n');
                                }
                                if (session != null) {
                                    session.getBasicRemote().sendText(sb.toString());
                                }
                                break block36;
                            }
                            if (line.startsWith("ping")) {
                                if (session != null) {
                                    session.getBasicRemote().sendPing(ByteBuffer.wrap("tyrus-client-ping".getBytes()));
                                }
                                break block36;
                            }
                            if (line.startsWith("exit")) break block37;
                            if (line.startsWith("quit")) {
                                break;
                            }
                            if (line.startsWith("help")) {
                                String help = "\n\topen uri : open a connection to the web socket uri\n\tclose : close a currently open web socket session\n\tsend message : send a text message\n\tsend : send a multiline text message teminated with a .\n\tping : send a ping message\n\tquit | exit : exit this tool\n\thelp : display this message\n\t";
                                ClientCli.print(console, null, help, false);
                            } else {
                                ClientCli.print(console, null, "Unable to parse given command.", false);
                            }
                        }
                        catch (IOException e) {
                            ClientCli.print(console, null, String.format("IOException: %s", e.getMessage()), false);
                        }
                    }
                    console.setPrompt(ClientCli.getPrompt());
                }
            }
            finally {
                try {
                    TerminalFactory.get().restore();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected static void connectToURI(ConsoleReader console, String uri, WebSocketContainer webSocketContainer) throws IOException {
        Session localCopy = session;
        if (localCopy != null) {
            ClientCli.print(console, null, String.format("Closing session %s", localCopy.getId()), false);
            localCopy.close();
        }
        ClientCli.print(console, null, String.format("Connecting to %s...", uri), false);
        try {
            session = localCopy = webSocketContainer.connectToServer(new ClientEndpoint(console), new URI(uri));
            ClientCli.print(console, null, String.format("Connected in session %s", localCopy.getId()), false);
        }
        catch (URISyntaxException ex) {
            ClientCli.print(console, null, String.format("Problem parsing uri %s beause of %s", uri, ex.getMessage()), false);
        }
        catch (DeploymentException ex) {
            ClientCli.print(console, null, String.format("Failed to connect to %s due to %s", uri, ex.getMessage()), false);
        }
    }

    private static String getPrompt() {
        Session currentSession = session;
        if (session != null) {
            String id = currentSession.getId();
            String shortId = id.substring(0, 4) + "..." + id.substring(id.length() - 4);
            return String.format(CONSOLE_PREFIX_CONN, shortId);
        }
        return CONSOLE_PREFIX_NO_CONN;
    }

    private static void print(ConsoleReader console, String prefix, String message) throws IOException {
        ClientCli.print(console, prefix, message, true);
    }

    private static synchronized void print(ConsoleReader console, String prefix, String message, boolean restore) throws IOException {
        String m;
        CursorBuffer cursorBuffer = console.getCursorBuffer().copy();
        String buffer = cursorBuffer.buffer.toString();
        int cursor = cursorBuffer.cursor;
        String prompt = console.getPrompt();
        console.restoreLine("", 0);
        String string = m = message == null ? "" : message;
        if (prefix != null && !prefix.isEmpty()) {
            console.println(String.format("# %s: %s", prefix, m));
        } else {
            console.println(String.format("# %s", m));
        }
        if (restore) {
            console.resetPromptLine(prompt, buffer, cursor);
        } else {
            console.restoreLine("", 0);
        }
    }

    @javax.websocket.ClientEndpoint
    public static class ClientEndpoint {
        private final ConsoleReader console;

        public ClientEndpoint(ConsoleReader console) {
            this.console = console;
        }

        @OnMessage
        public void onMessage(String s) throws IOException {
            this.print("text-message", s.replace("\n", "\n# "));
        }

        @OnMessage
        public void onMessage(byte[] buffer) throws IOException {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < buffer.length && i < 1024; ++i) {
                sb.append("0x");
                sb.append(Integer.toHexString(buffer[i]));
                sb.append(' ');
            }
            if (buffer.length >= 1024) {
                sb.append(" ...");
            }
            this.print("binary-message", sb.toString());
        }

        @OnError
        public void onError(Throwable th) throws IOException {
            this.print("error", th.getMessage());
        }

        @OnClose
        public void onClose(CloseReason closeReason) throws IOException {
            session = null;
            this.print("closed", closeReason.toString());
        }

        @OnMessage
        public void onMessage(PongMessage pongMessage) throws IOException {
            this.print(null, "pong-message");
        }

        private void print(String prefix, String message) throws IOException {
            ClientCli.print(this.console, prefix, message);
        }
    }
}

