/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.nio.tmpselectors;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.concurrent.TimeUnit;
import org.glassfish.grizzly.AbstractWriter;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.WriteHandler;
import org.glassfish.grizzly.WriteResult;
import org.glassfish.grizzly.asyncqueue.MessageCloner;
import org.glassfish.grizzly.asyncqueue.PushBackHandler;
import org.glassfish.grizzly.asyncqueue.WritableMessage;
import org.glassfish.grizzly.nio.NIOConnection;
import org.glassfish.grizzly.nio.tmpselectors.TemporarySelectorsEnabledTransport;

public abstract class TemporarySelectorWriter
extends AbstractWriter<SocketAddress> {
    protected final TemporarySelectorsEnabledTransport transport;

    public TemporarySelectorWriter(TemporarySelectorsEnabledTransport transport) {
        this.transport = transport;
    }

    @Override
    public void write(Connection connection, SocketAddress dstAddress, WritableMessage message, CompletionHandler<WriteResult<WritableMessage, SocketAddress>> completionHandler, MessageCloner<WritableMessage> messageCloner) {
        this.write(connection, dstAddress, message, completionHandler, null, connection.getWriteTimeout(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
    }

    @Override
    @Deprecated
    public void write(Connection connection, SocketAddress dstAddress, WritableMessage message, CompletionHandler<WriteResult<WritableMessage, SocketAddress>> completionHandler, PushBackHandler pushBackHandler) {
        this.write(connection, dstAddress, message, completionHandler, pushBackHandler, connection.getWriteTimeout(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
    }

    public void write(Connection connection, SocketAddress dstAddress, WritableMessage message, CompletionHandler<WriteResult<WritableMessage, SocketAddress>> completionHandler, long timeout, TimeUnit timeunit) {
        this.write(connection, dstAddress, message, completionHandler, null, timeout, timeunit);
    }

    public void write(Connection connection, SocketAddress dstAddress, WritableMessage message, CompletionHandler<WriteResult<WritableMessage, SocketAddress>> completionHandler, PushBackHandler pushBackHandler, long timeout, TimeUnit timeunit) {
        if (message == null) {
            TemporarySelectorWriter.failure(new IllegalStateException("Message cannot be null"), completionHandler);
            return;
        }
        if (connection == null || !(connection instanceof NIOConnection)) {
            TemporarySelectorWriter.failure(new IllegalStateException("Connection should be NIOConnection and cannot be null"), completionHandler);
            return;
        }
        NIOConnection nioConnection = (NIOConnection)connection;
        WriteResult<WritableMessage, SocketAddress> writeResult = WriteResult.create(connection, message, dstAddress, 0);
        try {
            this.write0(nioConnection, dstAddress, message, writeResult, timeout, timeunit);
            if (pushBackHandler != null) {
                pushBackHandler.onAccept(connection, message);
            }
            if (completionHandler != null) {
                completionHandler.completed(writeResult);
            }
            message.release();
        }
        catch (IOException e) {
            TemporarySelectorWriter.failure(e, completionHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long write0(NIOConnection connection, SocketAddress dstAddress, WritableMessage message, WriteResult<WritableMessage, SocketAddress> currentResult, long timeout, TimeUnit timeunit) throws IOException {
        SelectableChannel channel = connection.getChannel();
        long writeTimeout = TimeUnit.MILLISECONDS.convert(timeout, timeunit);
        SelectionKey key = null;
        Selector writeSelector = null;
        int attempts = 0;
        int bytesWritten = 0;
        try {
            NIOConnection nIOConnection = connection;
            synchronized (nIOConnection) {
                while (message.hasRemaining()) {
                    long len = this.writeNow0(connection, dstAddress, message, currentResult);
                    if (len > 0L) {
                        attempts = 0;
                        bytesWritten = (int)((long)bytesWritten + len);
                        continue;
                    }
                    ++attempts;
                    if (writeSelector == null) {
                        writeSelector = this.transport.getTemporarySelectorIO().getSelectorPool().poll();
                        if (writeSelector == null) continue;
                        key = channel.register(writeSelector, 4);
                    }
                    if (writeSelector.select(writeTimeout) != 0 || attempts <= 2) continue;
                    throw new IOException("Client disconnected");
                }
            }
        }
        finally {
            this.transport.getTemporarySelectorIO().recycleTemporaryArtifacts(writeSelector, key);
        }
        return bytesWritten;
    }

    public TemporarySelectorsEnabledTransport getTransport() {
        return this.transport;
    }

    protected abstract long writeNow0(NIOConnection var1, SocketAddress var2, WritableMessage var3, WriteResult<WritableMessage, SocketAddress> var4) throws IOException;

    private static void failure(Throwable failure, CompletionHandler<WriteResult<WritableMessage, SocketAddress>> completionHandler) {
        if (completionHandler != null) {
            completionHandler.failed(failure);
        }
    }

    @Override
    public boolean canWrite(Connection connection) {
        return true;
    }

    @Override
    public void notifyWritePossible(Connection connection, WriteHandler writeHandler) {
        try {
            writeHandler.onWritePossible();
        }
        catch (Throwable t) {
            writeHandler.onError(t);
        }
    }
}

