/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.core;

import java.nio.ByteBuffer;
import java.util.EnumSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import javax.websocket.CloseReason;
import javax.websocket.SendHandler;
import org.glassfish.tyrus.core.DataFrame;
import org.glassfish.tyrus.core.ProtocolHandler;
import org.glassfish.tyrus.core.WebSocket;
import org.glassfish.tyrus.core.WebSocketListener;
import org.glassfish.tyrus.core.frame.Frame;
import org.glassfish.tyrus.core.frame.PingFrame;
import org.glassfish.tyrus.core.frame.PongFrame;
import org.glassfish.tyrus.spi.UpgradeRequest;

public class TyrusWebSocket
implements WebSocket {
    private final WebSocketListener listener;
    private final ProtocolHandler protocolHandler;
    private final CountDownLatch onConnectLatch = new CountDownLatch(1);
    private final EnumSet<State> connected = EnumSet.range(State.CONNECTED, State.CLOSING);
    private final AtomicReference<State> state = new AtomicReference<State>(State.NEW);

    public TyrusWebSocket(ProtocolHandler protocolHandler, WebSocketListener listener) {
        this.protocolHandler = protocolHandler;
        this.listener = listener;
        protocolHandler.setWebSocket(this);
    }

    @Override
    public void setWriteTimeout(long timeoutMs) {
        this.protocolHandler.setWriteTimeout(timeoutMs);
    }

    @Override
    public boolean isConnected() {
        return this.connected.contains((Object)this.state.get());
    }

    @Override
    public void onClose(CloseReason closeReason) {
        if (this.listener != null) {
            this.listener.onClose(this, closeReason);
        }
        if (this.state.compareAndSet(State.CONNECTED, State.CLOSING)) {
            this.protocolHandler.close(closeReason.getCloseCode().getCode(), closeReason.getReasonPhrase());
        } else {
            this.state.set(State.CLOSED);
            this.protocolHandler.doClose();
        }
    }

    @Override
    public void onConnect(UpgradeRequest upgradeRequest) {
        this.state.set(State.CONNECTED);
        if (this.listener != null) {
            this.listener.onConnect(this, upgradeRequest);
        }
        this.onConnectLatch.countDown();
    }

    @Override
    public void onFragment(boolean last, byte[] fragment) {
        this.awaitOnConnect();
        if (this.listener != null) {
            this.listener.onFragment((WebSocket)this, fragment, last);
        }
    }

    @Override
    public void onFragment(boolean last, String fragment) {
        this.awaitOnConnect();
        if (this.listener != null) {
            this.listener.onFragment((WebSocket)this, fragment, last);
        }
    }

    @Override
    public void onMessage(byte[] data) {
        this.awaitOnConnect();
        if (this.listener != null) {
            this.listener.onMessage((WebSocket)this, data);
        }
    }

    @Override
    public void onMessage(String text) {
        this.awaitOnConnect();
        if (this.listener != null) {
            this.listener.onMessage((WebSocket)this, text);
        }
    }

    @Override
    public void onPing(DataFrame frame) {
        this.awaitOnConnect();
        if (this.listener != null) {
            this.listener.onPing(this, frame.getBytes());
        }
    }

    @Override
    public void onPong(DataFrame frame) {
        this.awaitOnConnect();
        if (this.listener != null) {
            this.listener.onPong(this, frame.getBytes());
        }
    }

    @Override
    public void close() {
        this.close(CloseReason.CloseCodes.NORMAL_CLOSURE.getCode(), null);
    }

    @Override
    public void close(int code, String reason) {
        if (this.state.compareAndSet(State.CONNECTED, State.CLOSING)) {
            this.protocolHandler.close(code, reason);
        }
    }

    @Override
    public Future<DataFrame> send(byte[] data) {
        if (this.isConnected()) {
            return this.protocolHandler.send(data);
        }
        throw new RuntimeException("Socket is not connected.");
    }

    @Override
    public void send(byte[] data, SendHandler handler) {
        if (!this.isConnected()) {
            throw new RuntimeException("Socket is not connected.");
        }
        this.protocolHandler.send(data, handler);
    }

    @Override
    public Future<DataFrame> send(String data) {
        if (this.isConnected()) {
            return this.protocolHandler.send(data);
        }
        throw new RuntimeException("Socket is not connected.");
    }

    @Override
    public void send(String data, SendHandler handler) {
        if (!this.isConnected()) {
            throw new RuntimeException("Socket is not connected");
        }
        this.protocolHandler.send(data, handler);
    }

    @Override
    public Future<DataFrame> sendRawFrame(ByteBuffer data) {
        if (this.isConnected()) {
            return this.protocolHandler.sendRawFrame(data);
        }
        throw new RuntimeException("Socket is not connected.");
    }

    @Override
    public Future<DataFrame> sendPing(byte[] data) {
        return this.send(new DataFrame((Frame)new PingFrame(), data));
    }

    @Override
    public Future<DataFrame> sendPong(byte[] data) {
        return this.send(new DataFrame((Frame)new PongFrame(), data));
    }

    private void awaitOnConnect() {
        try {
            this.onConnectLatch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private Future<DataFrame> send(DataFrame frame) {
        if (this.isConnected()) {
            return this.protocolHandler.send(frame);
        }
        throw new RuntimeException("Socket is not connected.");
    }

    @Override
    public Future<DataFrame> stream(boolean last, String fragment) {
        if (this.isConnected()) {
            return this.protocolHandler.stream(last, fragment);
        }
        throw new RuntimeException("Socket is not connected.");
    }

    @Override
    public Future<DataFrame> stream(boolean last, byte[] bytes, int off, int len) {
        if (this.isConnected()) {
            return this.protocolHandler.stream(last, bytes, off, len);
        }
        throw new RuntimeException("Socket is not connected.");
    }

    ProtocolHandler getProtocolHandler() {
        return this.protocolHandler;
    }

    static enum State {
        NEW,
        CONNECTED,
        CLOSING,
        CLOSED;

    }
}

