/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.container.grizzly.client;

import java.nio.ByteBuffer;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.EmptyCompletionHandler;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.tyrus.spi.CompletionHandler;
import org.glassfish.tyrus.spi.Writer;

public class GrizzlyWriter
extends Writer {
    private final Connection connection;

    public GrizzlyWriter(Connection connection) {
        this.connection = connection;
        this.connection.configureBlocking(false);
    }

    @Override
    public void write(final ByteBuffer buffer, final CompletionHandler<ByteBuffer> completionHandler) {
        if (!this.connection.isOpen()) {
            completionHandler.failed(new IllegalStateException("Connection is not open."));
            return;
        }
        Buffer message = Buffers.wrap(this.connection.getTransport().getMemoryManager(), buffer);
        EmptyCompletionHandler emptyCompletionHandler = new EmptyCompletionHandler(){

            @Override
            public void cancelled() {
                if (completionHandler != null) {
                    completionHandler.cancelled();
                }
            }

            @Override
            public void completed(Object result) {
                if (completionHandler != null) {
                    completionHandler.completed(buffer);
                }
            }

            @Override
            public void failed(Throwable throwable) {
                if (completionHandler != null) {
                    completionHandler.failed(throwable);
                }
            }
        };
        this.connection.write(message, emptyCompletionHandler);
    }

    @Override
    public void close() {
        this.connection.closeSilently();
    }

    public int hashCode() {
        return this.connection.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof GrizzlyWriter && this.connection.equals(((GrizzlyWriter)obj).connection);
    }

    public String toString() {
        return this.getClass().getName() + " " + this.connection.toString() + " " + this.connection.hashCode();
    }
}

