/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.core;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.glassfish.tyrus.spi.RemoteEndpoint;

class OutputStreamToAsyncBinaryAdapter
extends OutputStream {
    private final RemoteEndpoint re;

    public OutputStreamToAsyncBinaryAdapter(RemoteEndpoint re) {
        this.re = re;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        ByteBuffer result = ByteBuffer.allocate(len);
        result.put(Arrays.copyOfRange(b, off, len));
        result.flip();
        Future<?> future = this.re.sendBinary(result, false);
        try {
            future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new IOException(e.getCause());
        }
    }

    @Override
    public void write(int i) throws IOException {
        byte[] byteArray = new byte[]{(byte)i};
        this.write(byteArray, 0, byteArray.length);
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
        this.re.sendBinary(ByteBuffer.wrap(new byte[0]), true);
    }
}

