/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.core;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.util.Arrays;
import java.util.Locale;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.websocket.CloseReason;
import javax.websocket.SendHandler;
import javax.websocket.SendResult;
import javax.websocket.WebSocketContainer;
import org.glassfish.tyrus.core.ClosingDataFrame;
import org.glassfish.tyrus.core.DataFrame;
import org.glassfish.tyrus.core.ExecutorServiceProvider;
import org.glassfish.tyrus.core.Handshake;
import org.glassfish.tyrus.core.Masker;
import org.glassfish.tyrus.core.ProtocolError;
import org.glassfish.tyrus.core.StrictUtf8;
import org.glassfish.tyrus.core.TyrusFuture;
import org.glassfish.tyrus.core.TyrusWebSocketEngine;
import org.glassfish.tyrus.core.Utf8DecodingError;
import org.glassfish.tyrus.core.Utf8Utils;
import org.glassfish.tyrus.core.WebSocket;
import org.glassfish.tyrus.core.WebSocketApplication;
import org.glassfish.tyrus.core.WebSocketException;
import org.glassfish.tyrus.core.frame.BinaryFrame;
import org.glassfish.tyrus.core.frame.ClosingFrame;
import org.glassfish.tyrus.core.frame.ContinuationFrame;
import org.glassfish.tyrus.core.frame.Frame;
import org.glassfish.tyrus.core.frame.PingFrame;
import org.glassfish.tyrus.core.frame.PongFrame;
import org.glassfish.tyrus.core.frame.TextFrame;
import org.glassfish.tyrus.spi.CompletionHandler;
import org.glassfish.tyrus.spi.UpgradeRequest;
import org.glassfish.tyrus.spi.UpgradeResponse;
import org.glassfish.tyrus.spi.Writer;

public final class ProtocolHandler {
    private final Charset utf8 = new StrictUtf8();
    private final CharsetDecoder currentDecoder = this.utf8.newDecoder();
    private final AtomicBoolean onClosedCalled = new AtomicBoolean(false);
    private final boolean maskData;
    private final ParsingState state = new ParsingState();
    private WebSocket webSocket;
    private byte outFragmentedType;
    private ByteBuffer remainder;
    private long writeTimeoutMs = -1L;
    private WebSocketContainer container;
    private Writer writer;
    private byte inFragmentedType;
    private boolean processingFragment;

    public Writer getWriter() {
        return this.writer;
    }

    ProtocolHandler(boolean maskData) {
        this.maskData = maskData;
    }

    public Handshake handshake(WebSocketApplication app, UpgradeRequest request, UpgradeResponse response) {
        Handshake handshake = this.createHandShake(request);
        handshake.respond(response, app);
        return handshake;
    }

    public void setWriter(Writer handler) {
        this.writer = handler;
    }

    public void setWebSocket(WebSocket webSocket) {
        this.webSocket = webSocket;
    }

    Handshake createHandShake(UpgradeRequest webSocketRequest) {
        return Handshake.createServerHandShake(webSocketRequest);
    }

    public Handshake createClientHandShake(UpgradeRequest webSocketRequest) {
        return Handshake.createClientHandShake(webSocketRequest);
    }

    public final Future<DataFrame> send(DataFrame frame, boolean useTimeout) {
        return this.send(frame, null, (Boolean)useTimeout);
    }

    public final Future<DataFrame> send(DataFrame frame) {
        return this.send(frame, null, (Boolean)true);
    }

    Future<DataFrame> send(DataFrame frame, CompletionHandler<DataFrame> completionHandler, Boolean useTimeout) {
        return this.write(frame, completionHandler, (boolean)useTimeout);
    }

    Future<DataFrame> send(ByteBuffer frame, CompletionHandler<DataFrame> completionHandler, Boolean useTimeout) {
        return this.write(frame, completionHandler, (boolean)useTimeout);
    }

    public Future<DataFrame> send(byte[] data) {
        return this.send(new DataFrame((Frame)new BinaryFrame(), data), null, (Boolean)true);
    }

    public void send(byte[] data, final SendHandler handler) {
        this.send(new DataFrame((Frame)new BinaryFrame(), data), new CompletionHandler<DataFrame>(){

            @Override
            public void failed(Throwable throwable) {
                handler.onResult(new SendResult(throwable));
            }

            @Override
            public void completed(DataFrame result) {
                handler.onResult(new SendResult());
            }
        }, (Boolean)true);
    }

    public Future<DataFrame> send(String data) {
        return this.send(new DataFrame((Frame)new TextFrame(), data));
    }

    public void send(String data, final SendHandler handler) {
        this.send(new DataFrame((Frame)new TextFrame(), data), new CompletionHandler<DataFrame>(){

            @Override
            public void failed(Throwable throwable) {
                handler.onResult(new SendResult(throwable));
            }

            @Override
            public void completed(DataFrame result) {
                handler.onResult(new SendResult());
            }
        }, (Boolean)true);
    }

    public Future<DataFrame> sendRawFrame(ByteBuffer data) {
        return this.send(data, null, (Boolean)true);
    }

    public Future<DataFrame> stream(boolean last, byte[] bytes, int off, int len) {
        return this.send(new DataFrame((Frame)new BinaryFrame(), Arrays.copyOfRange(bytes, off, off + len), last));
    }

    public Future<DataFrame> stream(boolean last, String fragment) {
        return this.send(new DataFrame((Frame)new TextFrame(), fragment, last));
    }

    public Future<DataFrame> close(int code, String reason) {
        final CloseReason closeReason = new CloseReason(CloseReason.CloseCodes.getCloseCode(code), reason);
        ClosingDataFrame outgoingClosingFrame = code == CloseReason.CloseCodes.NO_STATUS_CODE.getCode() || code == CloseReason.CloseCodes.CLOSED_ABNORMALLY.getCode() || code == CloseReason.CloseCodes.TLS_HANDSHAKE_FAILURE.getCode() ? new ClosingDataFrame(CloseReason.CloseCodes.NORMAL_CLOSURE.getCode(), reason) : new ClosingDataFrame(code, reason);
        return this.send(outgoingClosingFrame, new CompletionHandler<DataFrame>(){

            @Override
            public void cancelled() {
                if (ProtocolHandler.this.webSocket != null && !ProtocolHandler.this.onClosedCalled.getAndSet(true)) {
                    ProtocolHandler.this.webSocket.onClose(closeReason);
                }
            }

            @Override
            public void failed(Throwable throwable) {
                if (ProtocolHandler.this.webSocket != null && !ProtocolHandler.this.onClosedCalled.getAndSet(true)) {
                    ProtocolHandler.this.webSocket.onClose(closeReason);
                }
            }

            @Override
            public void completed(DataFrame result) {
                if (!ProtocolHandler.this.maskData && ProtocolHandler.this.webSocket != null && !ProtocolHandler.this.onClosedCalled.getAndSet(true)) {
                    ProtocolHandler.this.webSocket.onClose(closeReason);
                }
            }
        }, (Boolean)false);
    }

    private Future<DataFrame> write(DataFrame frame, CompletionHandler<DataFrame> completionHandler, boolean useTimeout) {
        Writer localWriter = this.writer;
        TyrusFuture<DataFrame> future = new TyrusFuture<DataFrame>();
        if (localWriter == null) {
            throw new IllegalStateException("Connection is null");
        }
        ByteBuffer byteBuffer = this.frame(frame);
        localWriter.write(byteBuffer, new CompletionHandlerWrapper(completionHandler, future, frame));
        return future;
    }

    private Future<DataFrame> write(final ByteBuffer frame, final CompletionHandler<DataFrame> completionHandler, boolean useTimeout) {
        final Writer localWriter = this.writer;
        final TyrusFuture<DataFrame> future = new TyrusFuture<DataFrame>();
        if (localWriter == null) {
            throw new IllegalStateException("Connection is null");
        }
        if (useTimeout && this.writeTimeoutMs > 0L && this.container instanceof ExecutorServiceProvider) {
            ExecutorService executor = ((ExecutorServiceProvider)((Object)this.container)).getExecutorService();
            try {
                executor.submit(new Runnable(){

                    @Override
                    public void run() {
                        localWriter.write(frame, new CompletionHandlerWrapper(completionHandler, future, null));
                    }
                }).get(this.writeTimeoutMs, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                future.setFailure(e);
            }
            catch (ExecutionException e) {
                future.setFailure(e);
            }
            catch (TimeoutException e) {
                future.setFailure(e);
            }
        } else {
            localWriter.write(frame, new CompletionHandlerWrapper(completionHandler, future, null));
        }
        return future;
    }

    public DataFrame unframe(ByteBuffer buffer) {
        return this.parse(buffer);
    }

    long decodeLength(byte[] bytes) {
        return TyrusWebSocketEngine.toLong(bytes, 0, bytes.length);
    }

    byte[] encodeLength(long length) {
        byte[] lengthBytes;
        if (length <= 125L) {
            lengthBytes = new byte[]{(byte)length};
        } else {
            byte[] b = TyrusWebSocketEngine.toArray(length);
            if (length <= 65535L) {
                lengthBytes = new byte[3];
                lengthBytes[0] = 126;
                System.arraycopy(b, 6, lengthBytes, 1, 2);
            } else {
                lengthBytes = new byte[9];
                lengthBytes[0] = 127;
                System.arraycopy(b, 0, lengthBytes, 1, 8);
            }
        }
        return lengthBytes;
    }

    void validate(byte fragmentType, byte opcode) {
        if (fragmentType != 0 && opcode != fragmentType && !this.isControlFrame(opcode)) {
            throw new WebSocketException("Attempting to send a message while sending fragments of another");
        }
    }

    byte checkForLastFrame(DataFrame frame, byte opcode) {
        byte local = opcode;
        if (!frame.isLast()) {
            this.validate(this.outFragmentedType, local);
            if (this.outFragmentedType != 0) {
                local = 0;
            } else {
                this.outFragmentedType = local;
                local = (byte)(local & 0x7F);
            }
        } else if (this.outFragmentedType != 0) {
            local = -128;
            this.outFragmentedType = 0;
        } else {
            local = (byte)(local | 0x80);
        }
        return local;
    }

    public void doClose() {
        Writer localWriter = this.writer;
        if (localWriter == null) {
            throw new IllegalStateException("Connection is null");
        }
        try {
            localWriter.close();
        }
        catch (IOException e) {
            throw new IllegalStateException("IOException thrown when closing connection", e);
        }
    }

    void utf8Decode(boolean finalFragment, byte[] data, DataFrame dataFrame) {
        CharBuffer cb;
        block7: {
            ByteBuffer b = this.getByteBuffer(data);
            int n = (int)((float)b.remaining() * this.currentDecoder.averageCharsPerByte());
            cb = CharBuffer.allocate(n);
            while (true) {
                CoderResult result;
                if ((result = this.currentDecoder.decode(b, cb, finalFragment)).isUnderflow()) {
                    if (finalFragment) {
                        this.currentDecoder.flush(cb);
                        if (b.hasRemaining()) {
                            throw new IllegalStateException("Final UTF-8 fragment received, but not all bytes consumed by decode process");
                        }
                        this.currentDecoder.reset();
                    } else if (b.hasRemaining()) {
                        this.remainder = b;
                    }
                    break block7;
                }
                if (result.isOverflow()) {
                    CharBuffer tmp = CharBuffer.allocate(2 * n + 1);
                    cb.flip();
                    tmp.put(cb);
                    cb = tmp;
                    continue;
                }
                if (result.isError() || result.isMalformed()) break;
            }
            throw new Utf8DecodingError("Illegal UTF-8 Sequence");
        }
        cb.flip();
        String res = cb.toString();
        dataFrame.setPayload(res);
        dataFrame.setPayload(Utf8Utils.encode(new StrictUtf8(), res));
    }

    ByteBuffer getByteBuffer(byte[] data) {
        if (this.remainder == null) {
            return ByteBuffer.wrap(data);
        }
        int rem = this.remainder.remaining();
        byte[] orig = this.remainder.array();
        byte[] b = new byte[rem + data.length];
        System.arraycopy(orig, orig.length - rem, b, 0, rem);
        System.arraycopy(data, 0, b, rem, data.length);
        this.remainder = null;
        return ByteBuffer.wrap(b);
    }

    public void setWriteTimeout(long timeoutMs) {
        this.writeTimeoutMs = timeoutMs;
    }

    public void setContainer(WebSocketContainer container) {
        this.container = container;
    }

    public ByteBuffer frame(DataFrame frame) {
        byte opcode = this.checkForLastFrame(frame, this.getOpcode(frame.getType()));
        byte[] bytes = frame.getType().getBytes(frame);
        byte[] lengthBytes = this.encodeLength(bytes.length);
        int length = 1 + lengthBytes.length + bytes.length + (this.maskData ? 4 : 0);
        int payloadStart = 1 + lengthBytes.length + (this.maskData ? 4 : 0);
        byte[] packet = new byte[length];
        packet[0] = opcode;
        System.arraycopy(lengthBytes, 0, packet, 1, lengthBytes.length);
        if (this.maskData) {
            Masker masker = new Masker();
            packet[1] = (byte)(packet[1] | 0x80);
            masker.mask(packet, payloadStart, bytes);
            System.arraycopy(masker.getMask(), 0, packet, payloadStart - 4, 4);
        } else {
            System.arraycopy(bytes, 0, packet, payloadStart, bytes.length);
        }
        return ByteBuffer.wrap(packet);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    DataFrame parse(ByteBuffer buffer) {
        try {
            block8: while (true) {
                switch (this.state.state) {
                    case 0: {
                        byte lengthCode;
                        boolean rsvBitSet;
                        if (buffer.remaining() < 2) {
                            return null;
                        }
                        byte opcode = buffer.get();
                        boolean bl = rsvBitSet = this.isBitSet(opcode, 6) || this.isBitSet(opcode, 5) || this.isBitSet(opcode, 4);
                        if (rsvBitSet) {
                            throw new ProtocolError("RSV bit(s) incorrectly set.");
                        }
                        this.state.finalFragment = this.isBitSet(opcode, 7);
                        this.state.controlFrame = this.isControlFrame(opcode);
                        this.state.opcode = (byte)(opcode & 0x7F);
                        this.state.frame = this.valueOf(this.inFragmentedType, this.state.opcode);
                        if (!this.state.finalFragment && this.state.controlFrame) {
                            throw new ProtocolError("Fragmented control frame");
                        }
                        if (!this.state.controlFrame) {
                            if (this.isContinuationFrame(this.state.opcode) && !this.processingFragment) {
                                throw new ProtocolError("End fragment sent, but wasn't processing any previous fragments");
                            }
                            if (this.processingFragment && !this.isContinuationFrame(this.state.opcode)) {
                                throw new ProtocolError("Fragment sent but opcode was not 0");
                            }
                            if (!this.state.finalFragment && !this.isContinuationFrame(this.state.opcode)) {
                                this.processingFragment = true;
                            }
                            if (!this.state.finalFragment && this.inFragmentedType == 0) {
                                this.inFragmentedType = this.state.opcode;
                            }
                        }
                        this.state.masked = ((lengthCode = buffer.get()) & 0x80) == 128;
                        this.state.masker = new Masker(buffer);
                        if (this.state.masked) {
                            lengthCode = (byte)(lengthCode ^ 0x80);
                        }
                        this.state.lengthCode = lengthCode;
                        ++this.state.state;
                        continue block8;
                    }
                    case 1: {
                        if (this.state.lengthCode <= 125) {
                            this.state.length = this.state.lengthCode;
                        } else {
                            int lengthBytes;
                            if (this.state.controlFrame) {
                                throw new ProtocolError("Control frame payloads must be no greater than 125 bytes.");
                            }
                            int n = lengthBytes = this.state.lengthCode == 126 ? 2 : 8;
                            if (buffer.remaining() < lengthBytes) {
                                return null;
                            }
                            this.state.masker.setBuffer(buffer);
                            this.state.length = this.decodeLength(this.state.masker.unmask(lengthBytes));
                        }
                        ++this.state.state;
                        continue block8;
                    }
                    case 2: {
                        if (this.state.masked) {
                            if (buffer.remaining() < 4) {
                                return null;
                            }
                            this.state.masker.setBuffer(buffer);
                            this.state.masker.readMask();
                        }
                        ++this.state.state;
                        continue block8;
                    }
                    case 3: {
                        if ((long)buffer.remaining() < this.state.length) {
                            return null;
                        }
                        this.state.masker.setBuffer(buffer);
                        byte[] data = this.state.masker.unmask((int)this.state.length);
                        if ((long)data.length != this.state.length) {
                            throw new ProtocolError(String.format("Data read (%s) is not the expected size (%s)", data.length, this.state.length));
                        }
                        DataFrame dataFrame = this.state.frame.create(this.state.finalFragment, data);
                        if (!this.state.controlFrame && (this.isTextFrame(this.state.opcode) || this.inFragmentedType == 1)) {
                            this.utf8Decode(this.state.finalFragment, data, dataFrame);
                        }
                        if (!this.state.controlFrame && this.state.finalFragment) {
                            this.inFragmentedType = 0;
                            this.processingFragment = false;
                        }
                        this.state.recycle();
                        return dataFrame;
                    }
                }
                break;
            }
            throw new IllegalStateException("Unexpected state: " + this.state.state);
        }
        catch (Exception e) {
            this.state.recycle();
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    boolean isControlFrame(byte opcode) {
        return (opcode & 8) == 8;
    }

    private boolean isBitSet(byte b, int bit) {
        return (b >> bit & 1) != 0;
    }

    private boolean isContinuationFrame(byte opcode) {
        return opcode == 0;
    }

    private boolean isTextFrame(byte opcode) {
        return opcode == 1;
    }

    private byte getOpcode(Frame type) {
        if (type instanceof TextFrame) {
            return 1;
        }
        if (type instanceof BinaryFrame) {
            return 2;
        }
        if (type instanceof ClosingFrame) {
            return 8;
        }
        if (type instanceof PingFrame) {
            return 9;
        }
        if (type instanceof PongFrame) {
            return 10;
        }
        throw new ProtocolError("Unknown frame type: " + type.getClass().getName());
    }

    private Frame valueOf(byte fragmentType, byte value) {
        int opcode = value & 0xF;
        switch (opcode) {
            case 0: {
                return new ContinuationFrame((fragmentType & 1) == 1);
            }
            case 1: {
                return new TextFrame();
            }
            case 2: {
                return new BinaryFrame();
            }
            case 8: {
                return new ClosingFrame();
            }
            case 9: {
                return new PingFrame();
            }
            case 10: {
                return new PongFrame();
            }
        }
        throw new ProtocolError(String.format("Unknown frame type: %s, %s", Integer.toHexString(opcode & 0xFF).toUpperCase(Locale.US), this.writer));
    }

    private static class ParsingState {
        int state = 0;
        byte opcode = (byte)-1;
        long length = -1L;
        Frame frame;
        boolean masked;
        Masker masker;
        boolean finalFragment;
        boolean controlFrame;
        private byte lengthCode = (byte)-1;

        private ParsingState() {
        }

        void recycle() {
            this.state = 0;
            this.opcode = (byte)-1;
            this.length = -1L;
            this.lengthCode = (byte)-1;
            this.masked = false;
            this.masker = null;
            this.finalFragment = false;
            this.controlFrame = false;
            this.frame = null;
        }
    }

    private static class CompletionHandlerWrapper
    extends CompletionHandler<ByteBuffer> {
        private final CompletionHandler<DataFrame> frameCompletionHandler;
        private final TyrusFuture<DataFrame> future;
        private final DataFrame frame;

        private CompletionHandlerWrapper(CompletionHandler<DataFrame> frameCompletionHandler, TyrusFuture<DataFrame> future, DataFrame frame) {
            this.frameCompletionHandler = frameCompletionHandler;
            this.future = future;
            this.frame = frame;
        }

        @Override
        public void cancelled() {
            if (this.frameCompletionHandler != null) {
                this.frameCompletionHandler.cancelled();
            }
            if (this.future != null) {
                this.future.setFailure(new RuntimeException("Frame writing was canceled."));
            }
        }

        @Override
        public void failed(Throwable throwable) {
            if (this.frameCompletionHandler != null) {
                this.frameCompletionHandler.failed(throwable);
            }
            if (this.future != null) {
                this.future.setFailure(throwable);
            }
        }

        @Override
        public void completed(ByteBuffer result) {
            if (this.frameCompletionHandler != null) {
                this.frameCompletionHandler.completed(this.frame);
            }
            if (this.future != null) {
                this.future.setResult(this.frame);
            }
        }

        @Override
        public void updated(ByteBuffer result) {
            if (this.frameCompletionHandler != null) {
                this.frameCompletionHandler.updated(this.frame);
            }
        }
    }
}

