/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.core;

import java.nio.ByteBuffer;
import java.util.EnumSet;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import javax.websocket.CloseReason;
import javax.websocket.SendHandler;
import org.glassfish.tyrus.core.DataFrame;
import org.glassfish.tyrus.core.ProtocolHandler;
import org.glassfish.tyrus.core.WebSocket;
import org.glassfish.tyrus.core.WebSocketListener;
import org.glassfish.tyrus.core.frame.Frame;
import org.glassfish.tyrus.core.frame.PingFrame;
import org.glassfish.tyrus.core.frame.PongFrame;

public class TyrusWebSocket
implements WebSocket {
    private final Queue<WebSocketListener> listeners = new ConcurrentLinkedQueue<WebSocketListener>();
    private final ProtocolHandler protocolHandler;
    private final CountDownLatch onConnectLatch = new CountDownLatch(1);
    private final EnumSet<State> connected = EnumSet.range(State.CONNECTED, State.CLOSING);
    private final AtomicReference<State> state = new AtomicReference<State>(State.NEW);

    public TyrusWebSocket(ProtocolHandler protocolHandler, WebSocketListener ... listeners) {
        this.protocolHandler = protocolHandler;
        for (WebSocketListener listener : listeners) {
            this.add(listener);
        }
        protocolHandler.setWebSocket(this);
    }

    @Override
    public final boolean add(WebSocketListener listener) {
        return this.listeners.add(listener);
    }

    @Override
    public void setWriteTimeout(long timeoutMs) {
        this.protocolHandler.setWriteTimeout(timeoutMs);
    }

    @Override
    public boolean isConnected() {
        return this.connected.contains((Object)this.state.get());
    }

    public void setClosed() {
        this.state.set(State.CLOSED);
    }

    @Override
    public void onClose(CloseReason closeReason) {
        WebSocketListener listener;
        while ((listener = this.listeners.poll()) != null) {
            listener.onClose(this, closeReason);
        }
        if (this.state.compareAndSet(State.CONNECTED, State.CLOSING)) {
            this.protocolHandler.close(closeReason.getCloseCode().getCode(), closeReason.getReasonPhrase());
        } else {
            this.state.set(State.CLOSED);
            this.protocolHandler.doClose();
        }
    }

    @Override
    public void onConnect() {
        this.state.set(State.CONNECTED);
        for (WebSocketListener listener : this.listeners) {
            listener.onConnect(this);
        }
        this.onConnectLatch.countDown();
    }

    @Override
    public void onFragment(boolean last, byte[] fragment) {
        this.awaitOnConnect();
        for (WebSocketListener listener : this.listeners) {
            listener.onFragment((WebSocket)this, fragment, last);
        }
    }

    @Override
    public void onFragment(boolean last, String fragment) {
        this.awaitOnConnect();
        for (WebSocketListener listener : this.listeners) {
            listener.onFragment((WebSocket)this, fragment, last);
        }
    }

    @Override
    public void onMessage(byte[] data) {
        this.awaitOnConnect();
        for (WebSocketListener listener : this.listeners) {
            listener.onMessage((WebSocket)this, data);
        }
    }

    @Override
    public void onMessage(String text) {
        this.awaitOnConnect();
        for (WebSocketListener listener : this.listeners) {
            listener.onMessage((WebSocket)this, text);
        }
    }

    @Override
    public void onPing(DataFrame frame) {
        this.awaitOnConnect();
        for (WebSocketListener listener : this.listeners) {
            listener.onPing(this, frame.getBytes());
        }
    }

    @Override
    public void onPong(DataFrame frame) {
        this.awaitOnConnect();
        for (WebSocketListener listener : this.listeners) {
            listener.onPong(this, frame.getBytes());
        }
    }

    @Override
    public void close() {
        this.close(CloseReason.CloseCodes.NORMAL_CLOSURE.getCode(), null);
    }

    @Override
    public void close(int code, String reason) {
        if (this.state.compareAndSet(State.CONNECTED, State.CLOSING)) {
            this.protocolHandler.close(code, reason);
        }
    }

    @Override
    public Future<DataFrame> send(byte[] data) {
        if (this.isConnected()) {
            return this.protocolHandler.send(data);
        }
        throw new RuntimeException("Socket is not connected.");
    }

    @Override
    public void send(byte[] data, SendHandler handler) {
        if (!this.isConnected()) {
            throw new RuntimeException("Socket is not connected.");
        }
        this.protocolHandler.send(data, handler);
    }

    @Override
    public Future<DataFrame> send(String data) {
        if (this.isConnected()) {
            return this.protocolHandler.send(data);
        }
        throw new RuntimeException("Socket is not connected.");
    }

    @Override
    public void send(String data, SendHandler handler) {
        if (!this.isConnected()) {
            throw new RuntimeException("Socket is not connected");
        }
        this.protocolHandler.send(data, handler);
    }

    @Override
    public Future<DataFrame> sendRawFrame(ByteBuffer data) {
        if (this.isConnected()) {
            return this.protocolHandler.sendRawFrame(data);
        }
        throw new RuntimeException("Socket is not connected.");
    }

    @Override
    public Future<DataFrame> sendPing(byte[] data) {
        return this.send(new DataFrame((Frame)new PingFrame(), data));
    }

    @Override
    public Future<DataFrame> sendPong(byte[] data) {
        return this.send(new DataFrame((Frame)new PongFrame(), data));
    }

    private void awaitOnConnect() {
        try {
            this.onConnectLatch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private Future<DataFrame> send(DataFrame frame) {
        if (this.isConnected()) {
            return this.protocolHandler.send(frame);
        }
        throw new RuntimeException("Socket is not connected.");
    }

    @Override
    public Future<DataFrame> stream(boolean last, String fragment) {
        if (this.isConnected()) {
            return this.protocolHandler.stream(last, fragment);
        }
        throw new RuntimeException("Socket is not connected.");
    }

    @Override
    public Future<DataFrame> stream(boolean last, byte[] bytes, int off, int len) {
        if (this.isConnected()) {
            return this.protocolHandler.stream(last, bytes, off, len);
        }
        throw new RuntimeException("Socket is not connected.");
    }

    ProtocolHandler getProtocolHandler() {
        return this.protocolHandler;
    }

    static enum State {
        NEW,
        CONNECTED,
        CLOSING,
        CLOSED;

    }
}

