/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.core;

import java.nio.ByteBuffer;
import java.util.EnumSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import javax.websocket.CloseReason;
import javax.websocket.SendHandler;
import org.glassfish.tyrus.core.Frame;
import org.glassfish.tyrus.core.ProtocolHandler;
import org.glassfish.tyrus.core.TyrusEndpoint;
import org.glassfish.tyrus.core.frame.BinaryFrame;
import org.glassfish.tyrus.core.frame.CloseFrame;
import org.glassfish.tyrus.core.frame.PingFrame;
import org.glassfish.tyrus.core.frame.PongFrame;
import org.glassfish.tyrus.core.frame.TextFrame;
import org.glassfish.tyrus.spi.UpgradeRequest;

public class TyrusWebSocket {
    private final TyrusEndpoint tyrusEndpoint;
    private final ProtocolHandler protocolHandler;
    private final CountDownLatch onConnectLatch = new CountDownLatch(1);
    private final EnumSet<State> connected = EnumSet.range(State.CONNECTED, State.CLOSING);
    private final AtomicReference<State> state = new AtomicReference<State>(State.NEW);

    public TyrusWebSocket(ProtocolHandler protocolHandler, TyrusEndpoint tyrusEndpoint) {
        this.protocolHandler = protocolHandler;
        this.tyrusEndpoint = tyrusEndpoint;
        protocolHandler.setWebSocket(this);
    }

    public void setWriteTimeout(long timeoutMs) {
    }

    public boolean isConnected() {
        return this.connected.contains((Object)this.state.get());
    }

    public void onClose(CloseFrame frame) {
        CloseReason closeReason = frame.getCloseReason();
        if (this.tyrusEndpoint != null) {
            this.tyrusEndpoint.onClose(this, closeReason);
        }
        if (this.state.compareAndSet(State.CONNECTED, State.CLOSING)) {
            this.protocolHandler.close(closeReason.getCloseCode().getCode(), closeReason.getReasonPhrase());
        } else {
            this.state.set(State.CLOSED);
            this.protocolHandler.doClose();
        }
    }

    public void onConnect(UpgradeRequest upgradeRequest) {
        this.state.set(State.CONNECTED);
        if (this.tyrusEndpoint != null) {
            this.tyrusEndpoint.onConnect(this, upgradeRequest);
        }
        this.onConnectLatch.countDown();
    }

    public void onFragment(boolean last, BinaryFrame frame) {
        this.awaitOnConnect();
        if (this.tyrusEndpoint != null) {
            this.tyrusEndpoint.onFragment(this, frame.getPayloadData(), last);
        }
    }

    public void onFragment(boolean last, TextFrame frame) {
        this.awaitOnConnect();
        if (this.tyrusEndpoint != null) {
            this.tyrusEndpoint.onFragment(this, frame.getTextPayload(), last);
        }
    }

    public void onMessage(BinaryFrame frame) {
        this.awaitOnConnect();
        if (this.tyrusEndpoint != null) {
            this.tyrusEndpoint.onMessage(this, frame.getPayloadData());
        }
    }

    public void onMessage(TextFrame frame) {
        this.awaitOnConnect();
        if (this.tyrusEndpoint != null) {
            this.tyrusEndpoint.onMessage(this, frame.getTextPayload());
        }
    }

    public void onPing(PingFrame frame) {
        this.awaitOnConnect();
        if (this.tyrusEndpoint != null) {
            this.tyrusEndpoint.onPing(this, frame.getPayloadData());
        }
    }

    public void onPong(PongFrame frame) {
        this.awaitOnConnect();
        if (this.tyrusEndpoint != null) {
            this.tyrusEndpoint.onPong(this, frame.getPayloadData());
        }
    }

    public void close() {
        this.close(CloseReason.CloseCodes.NORMAL_CLOSURE.getCode(), null);
    }

    public void close(int code, String reason) {
        if (this.state.compareAndSet(State.CONNECTED, State.CLOSING)) {
            this.protocolHandler.close(code, reason);
        }
    }

    public Future<Frame> send(byte[] data) {
        if (this.isConnected()) {
            return this.protocolHandler.send(data);
        }
        throw new RuntimeException("Socket is not connected.");
    }

    public void send(byte[] data, SendHandler handler) {
        if (!this.isConnected()) {
            throw new RuntimeException("Socket is not connected.");
        }
        this.protocolHandler.send(data, handler);
    }

    public Future<Frame> send(String data) {
        if (this.isConnected()) {
            return this.protocolHandler.send(data);
        }
        throw new RuntimeException("Socket is not connected.");
    }

    public void send(String data, SendHandler handler) {
        if (!this.isConnected()) {
            throw new RuntimeException("Socket is not connected");
        }
        this.protocolHandler.send(data, handler);
    }

    public Future<Frame> sendRawFrame(ByteBuffer data) {
        if (this.isConnected()) {
            return this.protocolHandler.sendRawFrame(data);
        }
        throw new RuntimeException("Socket is not connected.");
    }

    public Future<Frame> sendPing(byte[] data) {
        return this.send(new PingFrame(data));
    }

    public Future<Frame> sendPong(byte[] data) {
        return this.send(new PongFrame(data));
    }

    private void awaitOnConnect() {
        try {
            this.onConnectLatch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private Future<Frame> send(Frame frame) {
        if (this.isConnected()) {
            return this.protocolHandler.send(frame);
        }
        throw new RuntimeException("Socket is not connected.");
    }

    public Future<Frame> stream(boolean last, String fragment) {
        if (this.isConnected()) {
            return this.protocolHandler.stream(last, fragment);
        }
        throw new RuntimeException("Socket is not connected.");
    }

    public Future<Frame> stream(boolean last, byte[] bytes, int off, int len) {
        if (this.isConnected()) {
            return this.protocolHandler.stream(last, bytes, off, len);
        }
        throw new RuntimeException("Socket is not connected.");
    }

    ProtocolHandler getProtocolHandler() {
        return this.protocolHandler;
    }

    static enum State {
        NEW,
        CONNECTED,
        CLOSING,
        CLOSED;

    }
}

