/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.server;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.EmptyCompletionHandler;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.ReadHandler;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.FilterChainEvent;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.filterchain.TransportFilter;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpContext;
import org.glassfish.grizzly.http.HttpPacket;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.Method;
import org.glassfish.grizzly.http.server.AfterServiceListener;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.HttpServerProbe;
import org.glassfish.grizzly.http.server.HttpServerProbeNotifier;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.Response;
import org.glassfish.grizzly.http.server.ServerFilterConfiguration;
import org.glassfish.grizzly.http.server.util.HtmlHelper;
import org.glassfish.grizzly.http.util.Header;
import org.glassfish.grizzly.http.util.HttpStatus;
import org.glassfish.grizzly.localization.LogMessages;
import org.glassfish.grizzly.monitoring.DefaultMonitoringConfig;
import org.glassfish.grizzly.monitoring.MonitoringAware;
import org.glassfish.grizzly.monitoring.MonitoringConfig;
import org.glassfish.grizzly.monitoring.MonitoringUtils;
import org.glassfish.grizzly.utils.DelayedExecutor;

public class HttpServerFilter
extends BaseFilter
implements MonitoringAware<HttpServerProbe> {
    private static final Logger LOGGER = Grizzly.logger(HttpHandler.class);
    private final FlushResponseHandler flushResponseHandler = new FlushResponseHandler();
    private final Attribute<Request> httpRequestInProgress;
    private final DelayedExecutor.DelayQueue<Response.SuspendTimeout> suspendedResponseQueue;
    private volatile HttpHandler httpHandler;
    private final ServerFilterConfiguration config;
    private volatile boolean isShuttingDown;
    private AtomicReference<CompletionHandler<HttpServerFilter>> shutdownCompletionHandlerRef;
    private final AtomicInteger activeRequestsCounter = new AtomicInteger();
    protected final DefaultMonitoringConfig<HttpServerProbe> monitoringConfig = new DefaultMonitoringConfig<HttpServerProbe>(HttpServerProbe.class){

        @Override
        public Object createManagementObject() {
            return HttpServerFilter.this.createJmxManagementObject();
        }
    };

    public HttpServerFilter(ServerFilterConfiguration config, DelayedExecutor delayedExecutor) {
        this.config = config;
        this.suspendedResponseQueue = Response.createDelayQueue(delayedExecutor);
        this.httpRequestInProgress = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute("HttpServerFilter.Request");
    }

    public HttpHandler getHttpHandler() {
        return this.httpHandler;
    }

    public void setHttpHandler(HttpHandler httpHandler) {
        this.httpHandler = httpHandler;
    }

    public ServerFilterConfiguration getConfiguration() {
        return this.config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NextAction handleRead(FilterChainContext ctx) throws IOException {
        Object message = ctx.getMessage();
        Connection connection = ctx.getConnection();
        if (HttpPacket.isHttp(message)) {
            HttpContent httpContent = (HttpContent)message;
            HttpContext context = HttpContext.get(ctx);
            Request handlerRequest = this.httpRequestInProgress.get(context);
            if (handlerRequest == null) {
                HttpRequestPacket request = (HttpRequestPacket)httpContent.getHttpHeader();
                HttpResponsePacket response = request.getResponse();
                this.activeRequestsCounter.incrementAndGet();
                handlerRequest = Request.create();
                handlerRequest.parameters.setLimit(this.config.getMaxRequestParameters());
                this.httpRequestInProgress.set(context, handlerRequest);
                Response handlerResponse = handlerRequest.getResponse();
                handlerRequest.initialize(request, ctx, this);
                handlerResponse.initialize(handlerRequest, response, ctx, this.suspendedResponseQueue, this);
                handlerRequest.addAfterServiceListener(this.flushResponseHandler);
                HttpServerProbeNotifier.notifyRequestReceive(this, connection, handlerRequest);
                boolean wasSuspended = false;
                try {
                    ctx.setMessage(handlerResponse);
                    if (!this.isShuttingDown) {
                        if (!this.config.isPassTraceRequest() && request.getMethod() == Method.TRACE) {
                            this.onTraceRequest(handlerRequest, handlerResponse);
                        } else {
                            HttpHandler httpHandlerLocal = this.httpHandler;
                            if (httpHandlerLocal != null) {
                                wasSuspended = !httpHandlerLocal.doHandle(handlerRequest, handlerResponse);
                            }
                        }
                    } else {
                        handlerResponse.getResponse().getProcessingState().setError(true);
                        HtmlHelper.setErrorAndSendErrorPage(handlerRequest, handlerResponse, this.config.getDefaultErrorPageGenerator(), 503, HttpStatus.SERVICE_UNAVAILABLE_503.getReasonPhrase(), "The server is being shutting down...", null);
                    }
                }
                catch (Exception t) {
                    LOGGER.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_HTTP_SERVER_FILTER_HTTPHANDLER_INVOCATION_ERROR(), t);
                    request.getProcessingState().setError(true);
                    if (!response.isCommitted()) {
                        HtmlHelper.setErrorAndSendErrorPage(handlerRequest, handlerResponse, this.config.getDefaultErrorPageGenerator(), 500, HttpStatus.INTERNAL_SERVER_ERROR_500.getReasonPhrase(), HttpStatus.INTERNAL_SERVER_ERROR_500.getReasonPhrase(), t);
                    }
                }
                catch (Throwable t) {
                    LOGGER.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_HTTP_SERVER_FILTER_UNEXPECTED(), t);
                    throw new IllegalStateException(t);
                }
                if (!wasSuspended) {
                    return this.afterService(ctx, connection, handlerRequest, handlerResponse);
                }
                return ctx.getSuspendAction();
            }
            try {
                ctx.suspend();
                NextAction action = ctx.getSuspendAction();
                if (!handlerRequest.getInputBuffer().append(httpContent)) {
                    ctx.completeAndRecycle();
                } else {
                    ctx.resume(ctx.getStopAction());
                }
                NextAction nextAction = action;
                return nextAction;
            }
            finally {
                httpContent.recycle();
            }
        }
        Response response = (Response)message;
        Request request = response.getRequest();
        return this.afterService(ctx, connection, request, response);
    }

    @Override
    public void exceptionOccurred(FilterChainContext ctx, Throwable error) {
        ReadHandler handler;
        HttpContext context = HttpContext.get(ctx);
        Request request = this.httpRequestInProgress.get(context);
        if (request != null && (handler = request.getInputBuffer().getReadHandler()) != null) {
            handler.onError(error);
        }
    }

    @Override
    public MonitoringConfig<HttpServerProbe> getMonitoringConfig() {
        return this.monitoringConfig;
    }

    public void prepareForShutdown(CompletionHandler<HttpServerFilter> shutdownCompletionHandler) {
        this.shutdownCompletionHandlerRef = new AtomicReference<CompletionHandler<HttpServerFilter>>(shutdownCompletionHandler);
        this.isShuttingDown = true;
        if (this.activeRequestsCounter.get() == 0 && this.shutdownCompletionHandlerRef.getAndSet(null) != null) {
            shutdownCompletionHandler.completed(this);
        }
    }

    protected Object createJmxManagementObject() {
        return MonitoringUtils.loadJmxObject("org.glassfish.grizzly.http.server.jmx.HttpServerFilter", this, HttpServerFilter.class);
    }

    protected void onTraceRequest(Request request, Response response) throws IOException {
        if (this.config.isTraceEnabled()) {
            HtmlHelper.writeTraceMessage(request, response);
        } else {
            response.setStatus(HttpStatus.METHOD_NOT_ALLOWED_405);
            response.setHeader(Header.Allow, "POST, GET, DELETE, OPTIONS, PUT, HEAD");
        }
    }

    protected String getFullServerName() {
        return this.config.getHttpServerName() + " " + this.config.getHttpServerVersion();
    }

    private NextAction afterService(FilterChainContext ctx, Connection connection, Request request, Response response) throws IOException {
        HttpContext context = HttpContext.get(ctx);
        this.httpRequestInProgress.remove(context);
        response.finish();
        request.onAfterService();
        HttpServerProbeNotifier.notifyRequestComplete(this, connection, response);
        HttpRequestPacket httpRequest = request.getRequest();
        boolean isBroken = httpRequest.isContentBroken();
        if (response.suspendState != Response.SuspendState.CANCELLED) {
            response.recycle();
            request.recycle();
        }
        if (isBroken) {
            NextAction suspendNextAction = ctx.getSuspendAction();
            ctx.completeAndRecycle();
            return suspendNextAction;
        }
        return ctx.getStopAction();
    }

    private void onRequestCompleteAndResponseFlushed() {
        int count = this.activeRequestsCounter.decrementAndGet();
        if (count == 0 && this.isShuttingDown) {
            CompletionHandler shutdownHandler;
            CompletionHandler completionHandler = shutdownHandler = this.shutdownCompletionHandlerRef != null ? (CompletionHandler)this.shutdownCompletionHandlerRef.getAndSet(null) : null;
            if (shutdownHandler != null) {
                shutdownHandler.completed(this);
            }
        }
    }

    private final class FlushResponseHandler
    extends EmptyCompletionHandler<Object>
    implements AfterServiceListener {
        private final FilterChainEvent event = TransportFilter.createFlushEvent(this);

        private FlushResponseHandler() {
        }

        @Override
        public void cancelled() {
            HttpServerFilter.this.onRequestCompleteAndResponseFlushed();
        }

        @Override
        public void failed(Throwable throwable) {
            HttpServerFilter.this.onRequestCompleteAndResponseFlushed();
        }

        @Override
        public void completed(Object result) {
            HttpServerFilter.this.onRequestCompleteAndResponseFlushed();
        }

        @Override
        public void onAfterService(Request request) {
            request.getContext().notifyDownstream(this.event);
        }
    }
}

