/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.core;

import java.lang.reflect.Method;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.websocket.WebSocketContainer;
import org.glassfish.tyrus.core.ExecutorServiceProvider;

public abstract class BaseContainer
extends ExecutorServiceProvider
implements WebSocketContainer {
    private static final Logger LOGGER = Logger.getLogger(BaseContainer.class.getName());
    private final ExecutorService executorService = this.newExecutorService();
    private final ScheduledExecutorService scheduledExecutorService = this.newScheduledExecutorService();
    private boolean shutdownExecutorService = true;
    private boolean shutdownScheduledExecutorService = true;
    private ThreadFactory threadFactory = null;

    @Override
    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public ScheduledExecutorService getScheduledExecutorService() {
        return this.scheduledExecutorService;
    }

    public void shutdown() {
        if (this.shutdownExecutorService) {
            this.executorService.shutdown();
        }
        if (this.shutdownScheduledExecutorService) {
            this.scheduledExecutorService.shutdown();
        }
    }

    private ExecutorService newExecutorService() {
        ExecutorService es = null;
        try {
            Class<?> aClass = Class.forName("javax.naming.InitialContext");
            Object o = aClass.newInstance();
            Method lookupMethod = aClass.getMethod("lookup", String.class);
            es = (ExecutorService)lookupMethod.invoke(o, "java:comp/DefaultManagedExecutorService");
            this.shutdownExecutorService = false;
        }
        catch (Exception e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, e.getMessage(), e);
            }
        }
        catch (LinkageError linkageError) {
            // empty catch block
        }
        if (es == null) {
            if (this.threadFactory == null) {
                this.threadFactory = new DaemonThreadFactory();
            }
            es = Executors.newCachedThreadPool(this.threadFactory);
        }
        return es;
    }

    private ScheduledExecutorService newScheduledExecutorService() {
        ScheduledExecutorService service = null;
        try {
            Class<?> aClass = Class.forName("javax.naming.InitialContext");
            Object o = aClass.newInstance();
            Method lookupMethod = aClass.getMethod("lookup", String.class);
            service = (ScheduledExecutorService)lookupMethod.invoke(o, "java:comp/DefaultManagedScheduledExecutorService");
            this.shutdownScheduledExecutorService = false;
        }
        catch (Exception e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, e.getMessage(), e);
            }
        }
        catch (LinkageError linkageError) {
            // empty catch block
        }
        if (service == null) {
            if (this.threadFactory == null) {
                this.threadFactory = new DaemonThreadFactory();
            }
            service = Executors.newScheduledThreadPool(10, this.threadFactory);
        }
        return service;
    }

    private static class DaemonThreadFactory
    implements ThreadFactory {
        static final AtomicInteger poolNumber = new AtomicInteger(1);
        final AtomicInteger threadNumber = new AtomicInteger(1);
        final String namePrefix = "tyrus-" + poolNumber.getAndIncrement() + "-thread-";

        DaemonThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(null, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (!t.isDaemon()) {
                t.setDaemon(true);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

