/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.ext.monitoring.jmx;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.glassfish.tyrus.ext.monitoring.jmx.ApplicationMXBean;
import org.glassfish.tyrus.ext.monitoring.jmx.BaseMXBeanImpl;
import org.glassfish.tyrus.ext.monitoring.jmx.Callable;
import org.glassfish.tyrus.ext.monitoring.jmx.EndpointClassNamePathPair;
import org.glassfish.tyrus.ext.monitoring.jmx.EndpointMXBean;
import org.glassfish.tyrus.ext.monitoring.jmx.ErrorCount;
import org.glassfish.tyrus.ext.monitoring.jmx.MessageStatisticsMXBean;
import org.glassfish.tyrus.ext.monitoring.jmx.MessageStatisticsSource;

class ApplicationMXBeanImpl
extends BaseMXBeanImpl
implements ApplicationMXBean,
Serializable {
    private static final long serialVersionUID = 5417841460238333390L;
    private final Callable<List<EndpointClassNamePathPair>> endpoints;
    private final Callable<List<String>> endpointPaths;
    private final ConcurrentHashMap<String, EndpointMXBean> endpointMXBeans = new ConcurrentHashMap();
    private final Callable<Integer> openSessionsCount;
    private final Callable<Integer> maxOpenSessionsCount;

    public ApplicationMXBeanImpl(MessageStatisticsSource sentMessageStatistics, MessageStatisticsSource receivedMessageStatistics, Callable<List<EndpointClassNamePathPair>> endpoints, Callable<List<String>> endpointPaths, Callable<Integer> openSessionsCount, Callable<Integer> maxOpenSessionsCount, Callable<List<ErrorCount>> errorCounts, MessageStatisticsMXBean textMessageStatisticsMXBean, MessageStatisticsMXBean binaryMessageStatisticsMXBean, MessageStatisticsMXBean controlMessageStatisticsMXBean) {
        super(sentMessageStatistics, receivedMessageStatistics, errorCounts, textMessageStatisticsMXBean, binaryMessageStatisticsMXBean, controlMessageStatisticsMXBean);
        this.endpoints = endpoints;
        this.endpointPaths = endpointPaths;
        this.openSessionsCount = openSessionsCount;
        this.maxOpenSessionsCount = maxOpenSessionsCount;
    }

    @Override
    public List<EndpointClassNamePathPair> getEndpoints() {
        return this.endpoints.call();
    }

    @Override
    public List<String> getEndpointPaths() {
        return this.endpointPaths.call();
    }

    @Override
    public List<EndpointMXBean> getEndpointMXBeans() {
        return new ArrayList<EndpointMXBean>(this.endpointMXBeans.values());
    }

    @Override
    public int getOpenSessionsCount() {
        return this.openSessionsCount.call();
    }

    @Override
    public int getMaximalOpenSessionsCount() {
        return this.maxOpenSessionsCount.call();
    }

    void putEndpointMXBean(String endpointPath, EndpointMXBean endpointMXBean) {
        this.endpointMXBeans.put(endpointPath, endpointMXBean);
    }

    void removeEndpointMXBean(String path) {
        this.endpointMXBeans.remove(path);
    }
}

