/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.ext.monitoring.jmx;

import java.io.Serializable;
import org.glassfish.tyrus.ext.monitoring.jmx.LongAdder;
import org.glassfish.tyrus.ext.monitoring.jmx.MessageStatisticsSource;

class ConcurrentMessageStatistics
implements MessageStatisticsSource,
Serializable {
    private static final long serialVersionUID = -54010795753428605L;
    private final LongAdder messagesCount = new LongAdder();
    private final LongAdder messagesSize = new LongAdder();
    private final Object minimalMessageSizeLock = new Object();
    private final Object maximalMessageSizeLock = new Object();
    private volatile long minimalMessageSize = Long.MAX_VALUE;
    private volatile long maximalMessageSize = 0L;

    ConcurrentMessageStatistics() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onMessage(long size) {
        Object object;
        this.messagesCount.increment();
        this.messagesSize.add(size);
        if (this.minimalMessageSize > size) {
            object = this.minimalMessageSizeLock;
            synchronized (object) {
                if (this.minimalMessageSize > size) {
                    this.minimalMessageSize = size;
                }
            }
        }
        if (this.maximalMessageSize < size) {
            object = this.maximalMessageSizeLock;
            synchronized (object) {
                if (this.maximalMessageSize < size) {
                    this.maximalMessageSize = size;
                }
            }
        }
    }

    @Override
    public long getMessagesCount() {
        return this.messagesCount.longValue();
    }

    @Override
    public long getMessagesSize() {
        return this.messagesSize.longValue();
    }

    @Override
    public long getMinMessageSize() {
        if (this.minimalMessageSize == Long.MAX_VALUE) {
            return 0L;
        }
        return this.minimalMessageSize;
    }

    @Override
    public long getMaxMessageSize() {
        return this.maximalMessageSize;
    }
}

