/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.ext.monitoring.jmx;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.glassfish.tyrus.ext.monitoring.jmx.Callable;
import org.glassfish.tyrus.ext.monitoring.jmx.ErrorCount;

class BaseMonitor {
    private final Map<String, AtomicLong> errorStatistics = new ConcurrentHashMap<String, AtomicLong>();
    private final Object errorStatisticsLock = new Object();

    BaseMonitor() {
    }

    Callable<List<ErrorCount>> getErrorCounts() {
        return new Callable<List<ErrorCount>>(){

            @Override
            public List<ErrorCount> call() {
                ArrayList<ErrorCount> errorCounts = new ArrayList<ErrorCount>();
                for (Map.Entry errorCount : BaseMonitor.this.errorStatistics.entrySet()) {
                    errorCounts.add(new ErrorCount((String)errorCount.getKey(), ((AtomicLong)errorCount.getValue()).get()));
                }
                return errorCounts;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onError(Throwable t) {
        String throwableClassName = t.getCause() == null ? t.getClass().getName() : t.getCause().getClass().getName();
        if (!this.errorStatistics.containsKey(throwableClassName)) {
            Object object = this.errorStatisticsLock;
            synchronized (object) {
                if (!this.errorStatistics.containsKey(throwableClassName)) {
                    this.errorStatistics.put(throwableClassName, new AtomicLong());
                }
            }
        }
        AtomicLong throwableCounter = this.errorStatistics.get(throwableClassName);
        throwableCounter.incrementAndGet();
    }
}

