/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.ext.monitoring.jmx;

import java.io.Serializable;
import org.glassfish.tyrus.ext.monitoring.jmx.MessageStatisticsMXBean;
import org.glassfish.tyrus.ext.monitoring.jmx.MessageStatisticsSource;

class MessageStatisticsMXBeanImpl
implements MessageStatisticsMXBean,
Serializable {
    private static final long serialVersionUID = -2156995729320425363L;
    private final MessageStatisticsSource sentMessageStatistics;
    private final MessageStatisticsSource receivedMessageStatistics;
    private final long monitoringStart;

    public MessageStatisticsMXBeanImpl(MessageStatisticsSource sentMessageStatistics, MessageStatisticsSource receivedMessageStatistics) {
        this.sentMessageStatistics = sentMessageStatistics;
        this.receivedMessageStatistics = receivedMessageStatistics;
        this.monitoringStart = System.currentTimeMillis();
    }

    @Override
    public long getSentMessagesCount() {
        return this.sentMessageStatistics.getMessagesCount();
    }

    @Override
    public long getMinimalSentMessageSize() {
        return this.sentMessageStatistics.getMinMessageSize();
    }

    @Override
    public long getMaximalSentMessageSize() {
        return this.sentMessageStatistics.getMaxMessageSize();
    }

    @Override
    public long getAverageSentMessageSize() {
        if (this.sentMessageStatistics.getMessagesCount() == 0L) {
            return 0L;
        }
        return this.sentMessageStatistics.getMessagesSize() / this.sentMessageStatistics.getMessagesCount();
    }

    @Override
    public long getSentMessagesCountPerSecond() {
        long time = this.getTimeSinceBeginningInSeconds();
        if (time == 0L) {
            return 0L;
        }
        return this.getSentMessagesCount() / time;
    }

    @Override
    public long getReceivedMessagesCount() {
        return this.receivedMessageStatistics.getMessagesCount();
    }

    @Override
    public long getMinimalReceivedMessageSize() {
        return this.receivedMessageStatistics.getMinMessageSize();
    }

    @Override
    public long getMaximalReceivedMessageSize() {
        return this.receivedMessageStatistics.getMaxMessageSize();
    }

    @Override
    public long getAverageReceivedMessageSize() {
        if (this.receivedMessageStatistics.getMessagesCount() == 0L) {
            return 0L;
        }
        return this.receivedMessageStatistics.getMessagesSize() / this.receivedMessageStatistics.getMessagesCount();
    }

    @Override
    public long getReceivedMessagesCountPerSecond() {
        long time = this.getTimeSinceBeginningInSeconds();
        if (time == 0L) {
            return 0L;
        }
        return this.getReceivedMessagesCount() / time;
    }

    private long getTimeSinceBeginningInSeconds() {
        long time = System.currentTimeMillis() - this.monitoringStart;
        return time / 1000L;
    }
}

