/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.ext.monitoring.jmx;

import java.util.concurrent.atomic.AtomicLong;
import org.glassfish.tyrus.ext.monitoring.jmx.BaseMonitor;
import org.glassfish.tyrus.ext.monitoring.jmx.EndpointMXBeanImpl;
import org.glassfish.tyrus.ext.monitoring.jmx.MBeanPublisher;
import org.glassfish.tyrus.ext.monitoring.jmx.MessageListener;
import org.glassfish.tyrus.ext.monitoring.jmx.MessageStatisticsAggregator;
import org.glassfish.tyrus.ext.monitoring.jmx.MessageStatisticsMXBeanImpl;
import org.glassfish.tyrus.ext.monitoring.jmx.MessageStatisticsSource;
import org.glassfish.tyrus.ext.monitoring.jmx.SessionMXBeanImpl;

class SessionMonitor
extends BaseMonitor
implements MessageListener {
    private final MessageStatistics sentTextMessageStatistics = new MessageStatistics();
    private final MessageStatistics sentBinaryMessageStatistics = new MessageStatistics();
    private final MessageStatistics sentControlMessageStatistics = new MessageStatistics();
    private final MessageStatistics receivedTextMessageStatistics = new MessageStatistics();
    private final MessageStatistics receivedBinaryMessageStatistics = new MessageStatistics();
    private final MessageStatistics receivedControlMessageStatistics = new MessageStatistics();
    private final String applicationName;
    private final String endpointPath;
    private final String sessionId;
    private final MessageListener messageListener;
    private final EndpointMXBeanImpl endpointMXBean;

    SessionMonitor(String applicationName, String endpointPath, String sessionId, MessageListener messageListener, EndpointMXBeanImpl endpointMXBean) {
        this.applicationName = applicationName;
        this.endpointPath = endpointPath;
        this.sessionId = sessionId;
        this.messageListener = messageListener;
        this.endpointMXBean = endpointMXBean;
        MessageStatisticsMXBeanImpl textMessagesMXBean = new MessageStatisticsMXBeanImpl(this.sentTextMessageStatistics, this.receivedTextMessageStatistics);
        MessageStatisticsMXBeanImpl binaryMessagesMXBean = new MessageStatisticsMXBeanImpl(this.sentBinaryMessageStatistics, this.receivedBinaryMessageStatistics);
        MessageStatisticsMXBeanImpl controlMessagesMXBean = new MessageStatisticsMXBeanImpl(this.sentControlMessageStatistics, this.receivedControlMessageStatistics);
        MessageStatisticsAggregator sentMessagesTotal = new MessageStatisticsAggregator(this.sentTextMessageStatistics, this.sentBinaryMessageStatistics, this.sentControlMessageStatistics);
        MessageStatisticsAggregator receivedMessagesTotal = new MessageStatisticsAggregator(this.receivedTextMessageStatistics, this.receivedBinaryMessageStatistics, this.receivedControlMessageStatistics);
        SessionMXBeanImpl sessionMXBean = new SessionMXBeanImpl(sentMessagesTotal, receivedMessagesTotal, this.getErrorCounts(), textMessagesMXBean, binaryMessagesMXBean, controlMessagesMXBean, sessionId);
        endpointMXBean.putSessionMXBean(sessionId, sessionMXBean);
        MBeanPublisher.registerSessionMXBeans(applicationName, endpointPath, sessionId, sessionMXBean, textMessagesMXBean, binaryMessagesMXBean, controlMessagesMXBean);
    }

    void unregister() {
        MBeanPublisher.unregisterSessionMXBeans(this.applicationName, this.endpointPath, this.sessionId);
        this.endpointMXBean.removeSessionMXBean(this.sessionId);
    }

    @Override
    public void onTextMessageSent(long length) {
        this.sentTextMessageStatistics.onMessage(length);
        this.messageListener.onTextMessageSent(length);
    }

    @Override
    public void onBinaryMessageSent(long length) {
        this.sentBinaryMessageStatistics.onMessage(length);
        this.messageListener.onBinaryMessageSent(length);
    }

    @Override
    public void onControlMessageSent(long length) {
        this.sentControlMessageStatistics.onMessage(length);
        this.messageListener.onControlMessageSent(length);
    }

    @Override
    public void onTextMessageReceived(long length) {
        this.receivedTextMessageStatistics.onMessage(length);
        this.messageListener.onTextMessageReceived(length);
    }

    @Override
    public void onBinaryMessageReceived(long length) {
        this.receivedBinaryMessageStatistics.onMessage(length);
        this.messageListener.onBinaryMessageReceived(length);
    }

    @Override
    public void onControlMessageReceived(long length) {
        this.receivedControlMessageStatistics.onMessage(length);
        this.messageListener.onControlMessageReceived(length);
    }

    private static class MessageStatistics
    implements MessageStatisticsSource {
        private final AtomicLong messagesCount = new AtomicLong(0L);
        private volatile long messagesSize = 0L;
        private volatile long minimalMessageSize = Long.MAX_VALUE;
        private volatile long maximalMessageSize = 0L;

        private MessageStatistics() {
        }

        void onMessage(long size) {
            this.messagesCount.incrementAndGet();
            this.messagesSize += size;
            if (this.minimalMessageSize > size) {
                this.minimalMessageSize = size;
            }
            if (this.maximalMessageSize < size) {
                this.maximalMessageSize = size;
            }
        }

        @Override
        public long getMessagesCount() {
            return this.messagesCount.get();
        }

        @Override
        public long getMessagesSize() {
            return this.messagesSize;
        }

        @Override
        public long getMinMessageSize() {
            if (this.minimalMessageSize == Long.MAX_VALUE) {
                return 0L;
            }
            return this.minimalMessageSize;
        }

        @Override
        public long getMaxMessageSize() {
            return this.maximalMessageSize;
        }
    }
}

