/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.ext.monitoring.jmx;

import java.util.concurrent.atomic.AtomicInteger;
import org.glassfish.tyrus.core.monitoring.MessageEventListener;
import org.glassfish.tyrus.ext.monitoring.jmx.ApplicationMXBeanImpl;
import org.glassfish.tyrus.ext.monitoring.jmx.ApplicationMonitor;
import org.glassfish.tyrus.ext.monitoring.jmx.Callable;
import org.glassfish.tyrus.ext.monitoring.jmx.EndpointMonitor;
import org.glassfish.tyrus.ext.monitoring.jmx.MessageEventListenerImpl;

class SessionlessEndpointMonitor
extends EndpointMonitor {
    private final AtomicInteger openSessionsCount = new AtomicInteger();

    SessionlessEndpointMonitor(ApplicationMonitor applicationJmx, ApplicationMXBeanImpl applicationMXBean, String applicationName, String endpointPath, String endpointClassName) {
        super(applicationJmx, applicationMXBean, applicationName, endpointPath, endpointClassName);
    }

    @Override
    protected Callable<Integer> getOpenSessionsCount() {
        return new Callable<Integer>(){

            @Override
            public Integer call() {
                return SessionlessEndpointMonitor.this.openSessionsCount.get();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageEventListener onSessionOpened(String sessionId) {
        this.applicationMonitor.onSessionOpened();
        this.openSessionsCount.incrementAndGet();
        if (this.openSessionsCount.get() > this.maxOpenSessionsCount) {
            Object object = this.maxOpenSessionsCountLock;
            synchronized (object) {
                if (this.openSessionsCount.get() > this.maxOpenSessionsCount) {
                    this.maxOpenSessionsCount = this.openSessionsCount.get();
                }
            }
        }
        return new MessageEventListenerImpl(this);
    }

    public void onSessionClosed(String sessionId) {
        this.applicationMonitor.onSessionClosed();
        this.openSessionsCount.decrementAndGet();
    }

    public void onError(String sessionId, Throwable t) {
        this.applicationMonitor.onError(t);
    }
}

