/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.ext.monitoring.jmx;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.glassfish.tyrus.core.monitoring.ApplicationEventListener;
import org.glassfish.tyrus.core.monitoring.EndpointEventListener;
import org.glassfish.tyrus.ext.monitoring.jmx.ApplicationMXBeanImpl;
import org.glassfish.tyrus.ext.monitoring.jmx.BaseMonitor;
import org.glassfish.tyrus.ext.monitoring.jmx.Callable;
import org.glassfish.tyrus.ext.monitoring.jmx.ConcurrentMessageStatistics;
import org.glassfish.tyrus.ext.monitoring.jmx.EndpointClassNamePathPair;
import org.glassfish.tyrus.ext.monitoring.jmx.EndpointMonitor;
import org.glassfish.tyrus.ext.monitoring.jmx.MBeanPublisher;
import org.glassfish.tyrus.ext.monitoring.jmx.MessageListener;
import org.glassfish.tyrus.ext.monitoring.jmx.MessageStatisticsAggregator;
import org.glassfish.tyrus.ext.monitoring.jmx.MessageStatisticsMXBeanImpl;
import org.glassfish.tyrus.ext.monitoring.jmx.SessionAwareEndpointMonitor;
import org.glassfish.tyrus.ext.monitoring.jmx.SessionlessEndpointMonitor;

class ApplicationMonitor
extends BaseMonitor
implements ApplicationEventListener,
MessageListener {
    private final Map<String, EndpointMonitor> endpoints = new ConcurrentHashMap<String, EndpointMonitor>();
    private final AtomicInteger openSessionsCount = new AtomicInteger(0);
    private final Object maxOpenSessionsCountLock = new Object();
    private final boolean monitorOnSessionLevel;
    private final ConcurrentMessageStatistics sentTextMessageStatistics = new ConcurrentMessageStatistics();
    private final ConcurrentMessageStatistics sentBinaryMessageStatistics = new ConcurrentMessageStatistics();
    private final ConcurrentMessageStatistics sentControlMessageStatistics = new ConcurrentMessageStatistics();
    private final ConcurrentMessageStatistics receivedTextMessageStatistics = new ConcurrentMessageStatistics();
    private final ConcurrentMessageStatistics receivedBinaryMessageStatistics = new ConcurrentMessageStatistics();
    private final ConcurrentMessageStatistics receivedControlMessageStatistics = new ConcurrentMessageStatistics();
    private volatile int maxOpenSessionCount = 0;
    private volatile String applicationName;
    private volatile ApplicationMXBeanImpl applicationMXBean;

    ApplicationMonitor(boolean monitorOnSessionLevel) {
        this.monitorOnSessionLevel = monitorOnSessionLevel;
    }

    public void onApplicationInitialized(String applicationName) {
        this.applicationName = applicationName;
        MessageStatisticsMXBeanImpl textMessagesMXBean = new MessageStatisticsMXBeanImpl(this.sentTextMessageStatistics, this.receivedTextMessageStatistics);
        MessageStatisticsMXBeanImpl controlMessagesMXBean = new MessageStatisticsMXBeanImpl(this.sentControlMessageStatistics, this.receivedControlMessageStatistics);
        MessageStatisticsMXBeanImpl binaryMessagesMXBean = new MessageStatisticsMXBeanImpl(this.sentBinaryMessageStatistics, this.receivedBinaryMessageStatistics);
        MessageStatisticsAggregator sentTotalStatistics = new MessageStatisticsAggregator(this.sentTextMessageStatistics, this.sentBinaryMessageStatistics, this.sentControlMessageStatistics);
        MessageStatisticsAggregator receivedTotalStatistics = new MessageStatisticsAggregator(this.receivedTextMessageStatistics, this.receivedBinaryMessageStatistics, this.receivedControlMessageStatistics);
        this.applicationMXBean = new ApplicationMXBeanImpl(sentTotalStatistics, receivedTotalStatistics, this.getEndpoints(), this.getEndpointPaths(), this.getOpenSessionsCount(), this.getMaxOpenSessionsCount(), this.getErrorCounts(), textMessagesMXBean, binaryMessagesMXBean, controlMessagesMXBean);
        MBeanPublisher.registerApplicationMXBeans(applicationName, this.applicationMXBean, textMessagesMXBean, binaryMessagesMXBean, controlMessagesMXBean);
    }

    public void onApplicationDestroyed() {
        MBeanPublisher.unregisterApplicationMXBeans(this.applicationName);
    }

    public EndpointEventListener onEndpointRegistered(String endpointPath, Class<?> endpointClass) {
        EndpointMonitor endpointJmx = this.monitorOnSessionLevel ? new SessionAwareEndpointMonitor(this, this.applicationMXBean, this.applicationName, endpointPath, endpointClass.getName()) : new SessionlessEndpointMonitor(this, this.applicationMXBean, this.applicationName, endpointPath, endpointClass.getName());
        this.endpoints.put(endpointPath, endpointJmx);
        return endpointJmx;
    }

    public void onEndpointUnregistered(String endpointPath) {
        EndpointMonitor endpoint = this.endpoints.remove(endpointPath);
        endpoint.unregister();
    }

    private Callable<List<EndpointClassNamePathPair>> getEndpoints() {
        return new Callable<List<EndpointClassNamePathPair>>(){

            @Override
            public List<EndpointClassNamePathPair> call() {
                ArrayList<EndpointClassNamePathPair> result = new ArrayList<EndpointClassNamePathPair>();
                for (EndpointMonitor endpoint : ApplicationMonitor.this.endpoints.values()) {
                    result.add(endpoint.getEndpointClassNamePathPair());
                }
                return result;
            }
        };
    }

    private Callable<List<String>> getEndpointPaths() {
        return new Callable<List<String>>(){

            @Override
            public List<String> call() {
                return new ArrayList<String>(ApplicationMonitor.this.endpoints.keySet());
            }
        };
    }

    private Callable<Integer> getOpenSessionsCount() {
        return new Callable<Integer>(){

            @Override
            public Integer call() {
                return ApplicationMonitor.this.openSessionsCount.get();
            }
        };
    }

    private Callable<Integer> getMaxOpenSessionsCount() {
        return new Callable<Integer>(){

            @Override
            public Integer call() {
                return ApplicationMonitor.this.maxOpenSessionCount;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onSessionOpened() {
        this.openSessionsCount.incrementAndGet();
        if (this.openSessionsCount.get() > this.maxOpenSessionCount) {
            Object object = this.maxOpenSessionsCountLock;
            synchronized (object) {
                if (this.openSessionsCount.get() > this.maxOpenSessionCount) {
                    this.maxOpenSessionCount = this.openSessionsCount.get();
                }
            }
        }
    }

    void onSessionClosed() {
        this.openSessionsCount.decrementAndGet();
    }

    @Override
    public void onTextMessageSent(long length) {
        this.sentTextMessageStatistics.onMessage(length);
    }

    @Override
    public void onBinaryMessageSent(long length) {
        this.sentBinaryMessageStatistics.onMessage(length);
    }

    @Override
    public void onControlMessageSent(long length) {
        this.sentControlMessageStatistics.onMessage(length);
    }

    @Override
    public void onTextMessageReceived(long length) {
        this.receivedTextMessageStatistics.onMessage(length);
    }

    @Override
    public void onBinaryMessageReceived(long length) {
        this.receivedBinaryMessageStatistics.onMessage(length);
    }

    @Override
    public void onControlMessageReceived(long length) {
        this.receivedControlMessageStatistics.onMessage(length);
    }
}

