/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.ext.monitoring.jmx;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.glassfish.tyrus.ext.monitoring.jmx.BaseMXBeanImpl;
import org.glassfish.tyrus.ext.monitoring.jmx.Callable;
import org.glassfish.tyrus.ext.monitoring.jmx.EndpointMXBean;
import org.glassfish.tyrus.ext.monitoring.jmx.ErrorCount;
import org.glassfish.tyrus.ext.monitoring.jmx.MessageStatisticsMXBean;
import org.glassfish.tyrus.ext.monitoring.jmx.MessageStatisticsSource;
import org.glassfish.tyrus.ext.monitoring.jmx.SessionMXBean;

class EndpointMXBeanImpl
extends BaseMXBeanImpl
implements EndpointMXBean,
Serializable {
    private static final long serialVersionUID = 1362028955470529660L;
    private final String endpointPath;
    private final String endpointClassName;
    private final Callable<Integer> openSessionsCount;
    private final Callable<Integer> maxOpenSessionsCount;
    private final Map<String, SessionMXBean> sessionMXBeans = new ConcurrentHashMap<String, SessionMXBean>();

    public EndpointMXBeanImpl(MessageStatisticsSource sentMessageStatistics, MessageStatisticsSource receivedMessageStatistics, String endpointPath, String endpointClassName, Callable<Integer> openSessionsCount, Callable<Integer> maxOpenSessionsCount, Callable<List<ErrorCount>> errorCounts, MessageStatisticsMXBean textMessageStatisticsMXBean, MessageStatisticsMXBean binaryMessageStatisticsMXBean, MessageStatisticsMXBean controlMessageStatisticsMXBean) {
        super(sentMessageStatistics, receivedMessageStatistics, errorCounts, textMessageStatisticsMXBean, binaryMessageStatisticsMXBean, controlMessageStatisticsMXBean);
        this.endpointPath = endpointPath;
        this.endpointClassName = endpointClassName;
        this.openSessionsCount = openSessionsCount;
        this.maxOpenSessionsCount = maxOpenSessionsCount;
    }

    @Override
    public String getEndpointPath() {
        return this.endpointPath;
    }

    @Override
    public String getEndpointClassName() {
        return this.endpointClassName;
    }

    @Override
    public int getOpenSessionsCount() {
        return this.openSessionsCount.call();
    }

    @Override
    public int getMaximalOpenSessionsCount() {
        return this.maxOpenSessionsCount.call();
    }

    @Override
    public List<SessionMXBean> getSessionMXBeans() {
        return new ArrayList<SessionMXBean>(this.sessionMXBeans.values());
    }

    void putSessionMXBean(String sessionId, SessionMXBean sessionMXBean) {
        this.sessionMXBeans.put(sessionId, sessionMXBean);
    }

    void removeSessionMXBean(String sessionId) {
        this.sessionMXBeans.remove(sessionId);
    }
}

