/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.ext.monitoring.jmx;

import org.glassfish.tyrus.core.frame.TyrusFrame;
import org.glassfish.tyrus.core.monitoring.MessageEventListener;
import org.glassfish.tyrus.ext.monitoring.jmx.MessageListener;

class MessageEventListenerImpl
implements MessageEventListener {
    private final MessageListener messageListener;

    MessageEventListenerImpl(MessageListener messageListener) {
        this.messageListener = messageListener;
    }

    public void onFrameSent(TyrusFrame.FrameType frameType, long payloadLength) {
        if (frameType == TyrusFrame.FrameType.TEXT || frameType == TyrusFrame.FrameType.TEXT_CONTINUATION) {
            this.messageListener.onTextMessageSent(payloadLength);
        }
        if (frameType == TyrusFrame.FrameType.BINARY || frameType == TyrusFrame.FrameType.BINARY_CONTINUATION) {
            this.messageListener.onBinaryMessageSent(payloadLength);
        }
        if (frameType == TyrusFrame.FrameType.PING || frameType == TyrusFrame.FrameType.PONG) {
            this.messageListener.onControlMessageSent(payloadLength);
        }
    }

    public void onFrameReceived(TyrusFrame.FrameType frameType, long payloadLength) {
        if (frameType == TyrusFrame.FrameType.TEXT || frameType == TyrusFrame.FrameType.TEXT_CONTINUATION) {
            this.messageListener.onTextMessageReceived(payloadLength);
        }
        if (frameType == TyrusFrame.FrameType.BINARY || frameType == TyrusFrame.FrameType.BINARY_CONTINUATION) {
            this.messageListener.onBinaryMessageReceived(payloadLength);
        }
        if (frameType == TyrusFrame.FrameType.PING || frameType == TyrusFrame.FrameType.PONG) {
            this.messageListener.onControlMessageReceived(payloadLength);
        }
    }
}

