/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.ext.monitoring.jmx;

import java.lang.management.ManagementFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.glassfish.tyrus.ext.monitoring.jmx.ApplicationMXBean;
import org.glassfish.tyrus.ext.monitoring.jmx.EndpointMXBean;
import org.glassfish.tyrus.ext.monitoring.jmx.MessageStatisticsMXBean;

class MBeanPublisher {
    private static final Logger LOGGER = Logger.getLogger(MBeanPublisher.class.getName());
    private static final String DOMAIN = "org.glassfish.tyrus";
    private static final String APPLICATION_NAME_BASE = "org.glassfish.tyrus:type=";
    private static final String ENDPOINT_KEY = ",endpoint=";
    private static final String SESSION_KEY = ",session=";
    private static final String MESSAGE_TYPE_KEY = ",message_type=";
    private static final String TEXT = "text";
    private static final String BINARY = "binary";
    private static final String CONTROL = "control";
    private static final String SESSIONS_DIRECTORY = ",sessions=sessions";
    private static final String ENDPOINTS_DIRECTORY = ",endpoints=endpoints";
    private static final String MESSAGE_STATISTIC_DIRECTORY = ",message_statistics=message_statistics";

    MBeanPublisher() {
    }

    static void registerApplicationMXBeans(String applicationName, ApplicationMXBean applicationMXBean, MessageStatisticsMXBean textMessageStatisticsMXBean, MessageStatisticsMXBean binaryMessageStatisticsMXBean, MessageStatisticsMXBean controlMessageStatisticsMXBean) {
        String nameBase = MBeanPublisher.getApplicationBeansBaseName(applicationName);
        MBeanPublisher.registerStatisticsMXBeans(nameBase, applicationMXBean, textMessageStatisticsMXBean, binaryMessageStatisticsMXBean, controlMessageStatisticsMXBean);
    }

    static void registerEndpointMXBeans(String applicationName, String endpointPath, EndpointMXBean endpointMXBean, MessageStatisticsMXBean textMessageStatisticsMXBean, MessageStatisticsMXBean binaryMessageStatisticsMXBean, MessageStatisticsMXBean controlMessageStatisticsMXBean) {
        String nameBase = MBeanPublisher.getEndpointBeansBaseName(applicationName, endpointPath);
        MBeanPublisher.registerStatisticsMXBeans(nameBase, endpointMXBean, textMessageStatisticsMXBean, binaryMessageStatisticsMXBean, controlMessageStatisticsMXBean);
    }

    static void registerSessionMXBeans(String applicationName, String endpointPath, String sessionId, MessageStatisticsMXBean sessionMXBean, MessageStatisticsMXBean textMessageStatisticsMXBean, MessageStatisticsMXBean binaryMessageStatisticsMXBean, MessageStatisticsMXBean controlMessageStatisticsMXBean) {
        String baseName = MBeanPublisher.getSessionBeansBaseName(applicationName, endpointPath, sessionId);
        MBeanPublisher.registerStatisticsMXBeans(baseName, sessionMXBean, textMessageStatisticsMXBean, binaryMessageStatisticsMXBean, controlMessageStatisticsMXBean);
    }

    static void unregisterApplicationMXBeans(String applicationName) {
        String name = MBeanPublisher.getApplicationBeansBaseName(applicationName);
        MBeanPublisher.unregisterMXBean(name);
    }

    static void unregisterEndpointMXBeans(String applicationName, String endpointPath) {
        String name = MBeanPublisher.getEndpointBeansBaseName(applicationName, endpointPath);
        MBeanPublisher.unregisterMXBean(name);
    }

    static void unregisterSessionMXBeans(String applicationName, String endpointPath, String sessionId) {
        String name = MBeanPublisher.getSessionBeansBaseName(applicationName, endpointPath, sessionId);
        MBeanPublisher.unregisterMXBean(name);
    }

    private static void registerStatisticsMXBeans(String nameBase, MessageStatisticsMXBean nodeMXBean, MessageStatisticsMXBean textMessageStatisticsMXBean, MessageStatisticsMXBean binaryMessageStatisticsMXBean, MessageStatisticsMXBean controlMessageStatisticsMXBean) {
        MBeanPublisher.registerMXBean(nameBase, nodeMXBean);
        String name = nameBase + ",message_statistics=message_statistics,message_type=text";
        MBeanPublisher.registerMXBean(name, textMessageStatisticsMXBean);
        name = nameBase + ",message_statistics=message_statistics,message_type=binary";
        MBeanPublisher.registerMXBean(name, binaryMessageStatisticsMXBean);
        name = nameBase + ",message_statistics=message_statistics,message_type=control";
        MBeanPublisher.registerMXBean(name, controlMessageStatisticsMXBean);
    }

    private static String getApplicationBeansBaseName(String applicationName) {
        return APPLICATION_NAME_BASE + applicationName;
    }

    private static String getEndpointBeansBaseName(String applicationName, String endpointPath) {
        return MBeanPublisher.getApplicationBeansBaseName(applicationName) + ",endpoints=endpoints,endpoint=" + endpointPath;
    }

    private static String getSessionBeansBaseName(String applicationName, String endpointPath, String sessionId) {
        return MBeanPublisher.getEndpointBeansBaseName(applicationName, endpointPath) + ",sessions=sessions,session=" + sessionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void registerMXBean(String name, Object mBean) {
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            Class<MBeanPublisher> clazz = MBeanPublisher.class;
            synchronized (MBeanPublisher.class) {
                ObjectName objectName = new ObjectName(name);
                if (mBeanServer.isRegistered(objectName)) {
                    LOGGER.log(Level.WARNING, "MXBean with name  already registered");
                } else {
                    mBeanServer.registerMBean(mBean, objectName);
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
        }
        catch (JMException e) {
            LOGGER.log(Level.WARNING, "Could not register MXBean with name " + name, e);
        }
        {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unregisterMXBean(String name) {
        name = (String)name + ",*";
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            Class<MBeanPublisher> clazz = MBeanPublisher.class;
            synchronized (MBeanPublisher.class) {
                for (ObjectName objectName : mBeanServer.queryNames(new ObjectName((String)name), null)) {
                    mBeanServer.unregisterMBean(objectName);
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
        }
        catch (JMException e) {
            LOGGER.log(Level.WARNING, "Could not unregister MXBeans with name " + (String)name, e);
        }
        {
            return;
        }
    }
}

