/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.ext.monitoring.jmx;

import org.glassfish.tyrus.core.monitoring.EndpointEventListener;
import org.glassfish.tyrus.ext.monitoring.jmx.ApplicationMXBeanImpl;
import org.glassfish.tyrus.ext.monitoring.jmx.ApplicationMonitor;
import org.glassfish.tyrus.ext.monitoring.jmx.BaseMonitor;
import org.glassfish.tyrus.ext.monitoring.jmx.Callable;
import org.glassfish.tyrus.ext.monitoring.jmx.ConcurrentMessageStatistics;
import org.glassfish.tyrus.ext.monitoring.jmx.EndpointClassNamePathPair;
import org.glassfish.tyrus.ext.monitoring.jmx.EndpointMXBeanImpl;
import org.glassfish.tyrus.ext.monitoring.jmx.MBeanPublisher;
import org.glassfish.tyrus.ext.monitoring.jmx.MessageListener;
import org.glassfish.tyrus.ext.monitoring.jmx.MessageStatisticsAggregator;
import org.glassfish.tyrus.ext.monitoring.jmx.MessageStatisticsMXBeanImpl;

abstract class EndpointMonitor
extends BaseMonitor
implements EndpointEventListener,
MessageListener {
    final EndpointClassNamePathPair endpointClassNamePathPair;
    final String applicationName;
    final Object maxOpenSessionsCountLock = new Object();
    final ApplicationMonitor applicationMonitor;
    final EndpointMXBeanImpl endpointMXBean;
    private final ApplicationMXBeanImpl applicationMXBean;
    private final ConcurrentMessageStatistics sentTextMessageStatistics = new ConcurrentMessageStatistics();
    private final ConcurrentMessageStatistics sentBinaryMessageStatistics = new ConcurrentMessageStatistics();
    private final ConcurrentMessageStatistics sentControlMessageStatistics = new ConcurrentMessageStatistics();
    private final ConcurrentMessageStatistics receivedTextMessageStatistics = new ConcurrentMessageStatistics();
    private final ConcurrentMessageStatistics receivedBinaryMessageStatistics = new ConcurrentMessageStatistics();
    private final ConcurrentMessageStatistics receivedControlMessageStatistics = new ConcurrentMessageStatistics();
    protected volatile int maxOpenSessionsCount = 0;

    EndpointMonitor(ApplicationMonitor applicationMonitor, ApplicationMXBeanImpl applicationMXBean, String applicationName, String endpointPath, String endpointClassName) {
        this.applicationName = applicationName;
        this.endpointClassNamePathPair = new EndpointClassNamePathPair(endpointPath, endpointClassName);
        this.applicationMonitor = applicationMonitor;
        this.applicationMXBean = applicationMXBean;
        MessageStatisticsMXBeanImpl textMessagesMXBean = new MessageStatisticsMXBeanImpl(this.sentTextMessageStatistics, this.receivedTextMessageStatistics);
        MessageStatisticsMXBeanImpl binaryMessagesMXBean = new MessageStatisticsMXBeanImpl(this.sentBinaryMessageStatistics, this.receivedBinaryMessageStatistics);
        MessageStatisticsMXBeanImpl controlMessagesMXBean = new MessageStatisticsMXBeanImpl(this.sentControlMessageStatistics, this.receivedControlMessageStatistics);
        MessageStatisticsAggregator sentTotalStatistics = new MessageStatisticsAggregator(this.sentTextMessageStatistics, this.sentBinaryMessageStatistics, this.sentControlMessageStatistics);
        MessageStatisticsAggregator receivedTotalStatistics = new MessageStatisticsAggregator(this.receivedTextMessageStatistics, this.receivedBinaryMessageStatistics, this.receivedControlMessageStatistics);
        this.endpointMXBean = new EndpointMXBeanImpl(sentTotalStatistics, receivedTotalStatistics, endpointPath, endpointClassName, this.getOpenSessionsCount(), this.getMaxOpenSessionsCount(), this.getErrorCounts(), textMessagesMXBean, binaryMessagesMXBean, controlMessagesMXBean);
        MBeanPublisher.registerEndpointMXBeans(applicationName, endpointPath, this.endpointMXBean, textMessagesMXBean, binaryMessagesMXBean, controlMessagesMXBean);
        applicationMXBean.putEndpointMXBean(endpointPath, this.endpointMXBean);
    }

    void unregister() {
        MBeanPublisher.unregisterEndpointMXBeans(this.applicationName, this.endpointClassNamePathPair.getEndpointPath());
        this.applicationMXBean.removeEndpointMXBean(this.endpointClassNamePathPair.getEndpointPath());
    }

    EndpointClassNamePathPair getEndpointClassNamePathPair() {
        return this.endpointClassNamePathPair;
    }

    protected abstract Callable<Integer> getOpenSessionsCount();

    private Callable<Integer> getMaxOpenSessionsCount() {
        return new Callable<Integer>(){

            @Override
            public Integer call() {
                return EndpointMonitor.this.maxOpenSessionsCount;
            }
        };
    }

    @Override
    public void onTextMessageSent(long length) {
        this.sentTextMessageStatistics.onMessage(length);
        this.applicationMonitor.onTextMessageSent(length);
    }

    @Override
    public void onBinaryMessageSent(long length) {
        this.sentBinaryMessageStatistics.onMessage(length);
        this.applicationMonitor.onBinaryMessageSent(length);
    }

    @Override
    public void onControlMessageSent(long length) {
        this.sentControlMessageStatistics.onMessage(length);
        this.applicationMonitor.onControlMessageSent(length);
    }

    @Override
    public void onTextMessageReceived(long length) {
        this.receivedTextMessageStatistics.onMessage(length);
        this.applicationMonitor.onTextMessageReceived(length);
    }

    @Override
    public void onBinaryMessageReceived(long length) {
        this.receivedBinaryMessageStatistics.onMessage(length);
        this.applicationMonitor.onBinaryMessageReceived(length);
    }

    @Override
    public void onControlMessageReceived(long length) {
        this.receivedControlMessageStatistics.onMessage(length);
        this.applicationMonitor.onControlMessageReceived(length);
    }
}

