/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.ext.monitoring.jmx;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.glassfish.tyrus.core.monitoring.MessageEventListener;
import org.glassfish.tyrus.ext.monitoring.jmx.ApplicationMXBeanImpl;
import org.glassfish.tyrus.ext.monitoring.jmx.ApplicationMonitor;
import org.glassfish.tyrus.ext.monitoring.jmx.Callable;
import org.glassfish.tyrus.ext.monitoring.jmx.EndpointMonitor;
import org.glassfish.tyrus.ext.monitoring.jmx.MessageEventListenerImpl;
import org.glassfish.tyrus.ext.monitoring.jmx.SessionMonitor;

class SessionAwareEndpointMonitor
extends EndpointMonitor {
    private final Map<String, SessionMonitor> sessions = new ConcurrentHashMap<String, SessionMonitor>();

    SessionAwareEndpointMonitor(ApplicationMonitor applicationJmx, ApplicationMXBeanImpl applicationMXBean, String applicationName, String endpointPath, String endpointClassName) {
        super(applicationJmx, applicationMXBean, applicationName, endpointPath, endpointClassName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageEventListener onSessionOpened(String sessionId) {
        SessionMonitor sessionMonitor = new SessionMonitor(this.applicationName, this.endpointClassNamePathPair.getEndpointPath(), sessionId, this, this.endpointMXBean);
        this.sessions.put(sessionId, sessionMonitor);
        if (this.sessions.size() > this.maxOpenSessionsCount) {
            Object object = this.maxOpenSessionsCountLock;
            synchronized (object) {
                if (this.sessions.size() > this.maxOpenSessionsCount) {
                    this.maxOpenSessionsCount = this.sessions.size();
                }
            }
        }
        this.applicationMonitor.onSessionOpened();
        return new MessageEventListenerImpl(sessionMonitor);
    }

    public void onSessionClosed(String sessionId) {
        SessionMonitor session = this.sessions.remove(sessionId);
        session.unregister();
        this.applicationMonitor.onSessionClosed();
    }

    @Override
    protected Callable<Integer> getOpenSessionsCount() {
        return new Callable<Integer>(){

            @Override
            public Integer call() {
                return SessionAwareEndpointMonitor.this.sessions.size();
            }
        };
    }

    public void onError(String sessionId, Throwable t) {
        SessionMonitor sessionMonitor = this.sessions.get(sessionId);
        sessionMonitor.onError(t);
        this.applicationMonitor.onError(t);
    }
}

