/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.sample.btc.xchange;

import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.json.Json;
import javax.json.JsonObject;
import javax.websocket.CloseReason;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;
import org.glassfish.tyrus.sample.btc.xchange.Market;

@ServerEndpoint(value="/market")
public class MarketEndpoint
implements Market.MarketListener {
    private final Market market = Market.getInstance();
    private volatile long lastId;
    private volatile Session session;
    private volatile ScheduledFuture<?> scheduledFuture;
    private volatile long btc;
    private volatile long usd;

    @OnOpen
    public void onOpen(Session session) throws IOException {
        session.getBasicRemote().sendText(Json.createObjectBuilder().add("type", "name").build().toString());
        this.session = session;
        this.market.registerMarketListener((Market.MarketListener)this);
        this.scheduledFuture = Executors.newSingleThreadScheduledExecutor().scheduleAtFixedRate((Runnable)new /* Unavailable Anonymous Inner Class!! */, 0L, 1L, TimeUnit.SECONDS);
        this.onBalanceChange(Long.valueOf(30000L), Long.valueOf(3000L));
    }

    @OnMessage
    public void onMessage(Session session, Reader reader) throws IOException {
        JsonObject jsonObject = Json.createReader((Reader)reader).readObject();
        this.market.realize((Market.MarketListener)this, (long)jsonObject.getInt("id"));
    }

    @OnClose
    public void onClose(Session session, CloseReason closeReason) {
        System.out.println("onClose: " + closeReason);
        this.market.unregisterMarketListener((Market.MarketListener)this);
        this.scheduledFuture.cancel(true);
    }

    @OnError
    public void onError(Session session, Throwable t) {
        System.out.println("onError: " + t);
    }

    public void onNewOffer() {
        List offers = this.market.getOffers(this.lastId);
        for (Market.Offer offer : offers) {
            try {
                this.session.getBasicRemote().sendText(Json.createObjectBuilder().add("id", offer.id).add("type", offer.type).add("amount", offer.amount).add("price", offer.price).build().toString());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (offer.id <= this.lastId) continue;
            this.lastId = offer.id;
        }
    }

    public void onRemoved(Long id) {
        try {
            this.session.getBasicRemote().sendText(Json.createObjectBuilder().add("id", id.longValue()).add("type", "invalidate").build().toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void onBalanceChange(Long btc, Long usd) {
        System.out.println("onBalanceChange: " + btc + " " + usd);
        this.btc += btc.longValue();
        this.usd += usd.longValue();
        try {
            this.session.getBasicRemote().sendText(Json.createObjectBuilder().add("type", "balance").add("btc", this.btc).add("usd", this.usd).add("btcDelta", btc.longValue()).add("usdDelta", usd.longValue()).build().toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static /* synthetic */ Market access$000(MarketEndpoint x0) {
        return x0.market;
    }
}

