/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.sample.btc.xchange;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.glassfish.tyrus.sample.btc.xchange.Market;

public class Market {
    private static final Market instance = new Market();
    private final Map<Long, Offer> map = new ConcurrentHashMap();
    private final Map<MarketListener, Boolean> endpoints = new ConcurrentHashMap();
    private final AtomicLong idCounter = new AtomicLong(0L);
    private volatile int lastPrice = 250;

    public static Market getInstance() {
        return instance;
    }

    private Market() {
        ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
        scheduledExecutorService.scheduleAtFixedRate((Runnable)new /* Unavailable Anonymous Inner Class!! */, 0L, 3L, TimeUnit.SECONDS);
        scheduledExecutorService.scheduleAtFixedRate((Runnable)new /* Unavailable Anonymous Inner Class!! */, 5L, 4L, TimeUnit.SECONDS);
    }

    public void registerMarketListener(MarketListener transactionsEndpoint) {
        this.endpoints.put(transactionsEndpoint, true);
    }

    public void unregisterMarketListener(MarketListener transactionsEndpoint) {
        this.endpoints.remove(transactionsEndpoint);
    }

    public int getCurrentPrice() {
        return this.lastPrice;
    }

    public List<Offer> getOffers(long fromId) {
        ArrayList<Offer> offers = new ArrayList<Offer>();
        for (Offer offer : this.map.values()) {
            if (offer.id <= fromId) continue;
            offers.add(offer);
        }
        return offers;
    }

    public boolean realize(MarketListener trader, long id) {
        Offer remove = (Offer)this.map.remove(id);
        if (remove == null) {
            return false;
        }
        this.lastPrice = remove.price;
        for (MarketListener listener : this.endpoints.keySet()) {
            listener.onRemoved(Long.valueOf(id));
        }
        if (trader == null) {
            return true;
        }
        if (remove.type.equals("buy")) {
            trader.onBalanceChange(Long.valueOf(remove.amount), Long.valueOf(-((long)((double)remove.price * ((double)remove.amount / 1000.0)))));
        } else if (remove.type.equals("sell")) {
            trader.onBalanceChange(Long.valueOf(-((long)remove.amount)), Long.valueOf((long)((double)remove.price * ((double)remove.amount / 1000.0))));
        }
        return true;
    }

    static /* synthetic */ AtomicLong access$000(Market x0) {
        return x0.idCounter;
    }

    static /* synthetic */ Map access$100(Market x0) {
        return x0.map;
    }

    static /* synthetic */ Map access$200(Market x0) {
        return x0.endpoints;
    }
}

