/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.sample.cdi;

import jakarta.annotation.PostConstruct;
import jakarta.ejb.Singleton;
import jakarta.interceptor.Interceptors;
import jakarta.websocket.OnMessage;
import jakarta.websocket.server.ServerEndpoint;
import java.util.concurrent.atomic.AtomicInteger;
import org.glassfish.tyrus.sample.cdi.LoggingInterceptor;

@ServerEndpoint(value="/singleton")
@Singleton
@Interceptors(value={LoggingInterceptor.class})
public class SingletonEndpoint {
    private final AtomicInteger counter = new AtomicInteger(0);
    private volatile boolean postConstructCalled = false;
    private volatile boolean interceptorCalled = false;

    @OnMessage
    public String echo(String message) {
        return this.postConstructCalled && this.interceptorCalled ? String.format("%s:%s", message, this.counter.incrementAndGet()) : "PostConstruct not called.";
    }

    @PostConstruct
    public void postConstruct() {
        this.postConstructCalled = true;
    }

    public void onInterceptorCalled() {
        this.interceptorCalled = true;
    }
}

