/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.sample.chat;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import javax.websocket.CloseReason;
import javax.websocket.RemoteEndpoint;
import javax.websocket.Session;
import javax.websocket.WebSocketClose;
import javax.websocket.WebSocketEndpoint;
import javax.websocket.WebSocketMessage;
import javax.websocket.WebSocketOpen;
import org.glassfish.tyrus.sample.chat.chatdata.ChatTranscriptUpdateMessage;
import org.glassfish.tyrus.sample.chat.chatdata.ChatUpdateDecoder;
import org.glassfish.tyrus.sample.chat.chatdata.ChatUpdateMessage;
import org.glassfish.tyrus.sample.chat.chatdata.DisconnectRequestDecoder;
import org.glassfish.tyrus.sample.chat.chatdata.DisconnectRequestMessage;
import org.glassfish.tyrus.sample.chat.chatdata.DisconnectResponseEncoder;
import org.glassfish.tyrus.sample.chat.chatdata.DisconnectResponseMessage;
import org.glassfish.tyrus.sample.chat.chatdata.LoginRequestDecoder;
import org.glassfish.tyrus.sample.chat.chatdata.LoginRequestMessage;
import org.glassfish.tyrus.sample.chat.chatdata.LoginResponseMessage;
import org.glassfish.tyrus.sample.chat.chatdata.UserListUpdateMessage;

@WebSocketEndpoint(value="/chat", decoders={LoginRequestDecoder.class, ChatUpdateDecoder.class, DisconnectRequestDecoder.class}, encoders={DisconnectResponseEncoder.class})
public class ChatServer {
    static final Logger logger = Logger.getLogger("application");
    private ConcurrentHashMap<String, Session> connections = new ConcurrentHashMap();
    private List<String> chatTranscript = new ArrayList();
    static int transcriptMaxLines = 20;

    @WebSocketOpen
    public void init(Session s) {
        logger.info("############Someone connected...");
    }

    @WebSocketMessage
    public void handleLoginRequest(LoginRequestMessage lrm, Session session) {
        String newUsername = this.registerNewUsername(lrm.getUsername(), session);
        logger.info("Signing " + newUsername + " into chat.");
        LoginResponseMessage lres = new LoginResponseMessage(newUsername);
        try {
            session.getRemote().sendString(lres.asString());
        }
        catch (IOException ioe) {
            logger.warning("Error signing " + lrm.getUsername() + " into chat : " + ioe.getMessage());
        }
        this.addToTranscriptAndNotify(newUsername, " has just joined.");
        this.broadcastUserList();
    }

    @WebSocketMessage
    public void handleChatMessage(ChatUpdateMessage cum) {
        logger.info("Receiving chat message from " + cum.getUsername());
        this.addToTranscriptAndNotify(cum.getUsername(), cum.getMessage());
    }

    @WebSocketMessage
    public DisconnectResponseMessage handleDisconnectRequest(DisconnectRequestMessage drm) {
        logger.info(drm.getUsername() + " would like to leave chat");
        DisconnectResponseMessage reply = new DisconnectResponseMessage(drm.getUsername());
        this.addToTranscriptAndNotify(drm.getUsername(), " has just left.");
        this.removeUserAndBroadcast(drm.getUsername());
        return reply;
    }

    @WebSocketClose
    public void handleClientClose(Session session) {
        String username = null;
        logger.info("The web socket closed");
        for (String s : this.connections.keySet()) {
            if (!session.equals(this.connections.get(s))) continue;
            username = s;
        }
        if (username != null) {
            this.removeUserAndBroadcast(username);
            this.addToTranscriptAndNotify(username, " has just left...rather abruptly !");
        }
    }

    private void broadcastUserList() {
        logger.info("Broadcasting updated user list");
        UserListUpdateMessage ulum = new UserListUpdateMessage(new ArrayList(this.connections.keySet()));
        for (Session nextSession : this.connections.values()) {
            RemoteEndpoint remote = nextSession.getRemote();
            try {
                remote.sendString(ulum.asString());
            }
            catch (IOException ioe) {
                logger.warning("Error updating a client " + remote + " : " + ioe.getMessage());
            }
        }
    }

    private void removeUserAndBroadcast(String username) {
        logger.info("Removing " + username + " from chat.");
        Session nextSession = (Session)this.connections.get(username);
        try {
            nextSession.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.NORMAL_CLOSURE, "User logged off"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.connections.remove(username);
        this.broadcastUserList();
    }

    private void broadcastUpdatedTranscript() {
        ArrayList<String> transcriptEntry = new ArrayList<String>();
        transcriptEntry.add(((String)this.chatTranscript.get(this.chatTranscript.size() - 1)).toString());
        logger.info("Broadcasting updated transcript with " + transcriptEntry);
        for (Session nextSession : this.connections.values()) {
            RemoteEndpoint remote = nextSession.getRemote();
            if (remote == null) continue;
            ChatTranscriptUpdateMessage cm = new ChatTranscriptUpdateMessage(transcriptEntry);
            try {
                remote.sendString(cm.asString());
            }
            catch (IOException ioe) {
                logger.warning("Error updating a client " + remote + " : " + ioe.getMessage());
            }
        }
    }

    private void addToTranscriptAndNotify(String user, String message) {
        if (this.chatTranscript.size() > transcriptMaxLines) {
            this.chatTranscript.remove(0);
        }
        this.chatTranscript.add(user + "> " + message);
        this.broadcastUpdatedTranscript();
    }

    private String registerNewUsername(String newUsername, Session session) {
        if (this.connections.containsKey(newUsername)) {
            return this.registerNewUsername(newUsername + "1", session);
        }
        this.connections.put(newUsername, session);
        return newUsername;
    }
}

