/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.sample.chat.chatdata;

import java.util.ArrayList;
import org.glassfish.tyrus.sample.chat.chatdata.ChatTranscriptUpdateMessage;
import org.glassfish.tyrus.sample.chat.chatdata.ChatUpdateMessage;
import org.glassfish.tyrus.sample.chat.chatdata.DisconnectRequestMessage;
import org.glassfish.tyrus.sample.chat.chatdata.DisconnectResponseMessage;
import org.glassfish.tyrus.sample.chat.chatdata.LoginRequestMessage;
import org.glassfish.tyrus.sample.chat.chatdata.LoginResponseMessage;
import org.glassfish.tyrus.sample.chat.chatdata.UserListUpdateMessage;

public abstract class ChatMessage {
    public static final String LOGIN_REQUEST = "lreq";
    public static final String LOGIN_RESPONSE = "lres";
    public static final String USERLIST_UPDATE = "ulupd";
    public static final String CHAT_MESSAGE = "ctmsg";
    public static final String CHATTRANSCRIPT_UPDATE = "ctupd";
    public static final String DISCONNECT_REQUEST = "dreq";
    public static final String DISCONNECT_RESPONSE = "dres";
    public static final String SEP = ":";
    String type;

    public static void main(String[] args) {
        LoginRequestMessage login = new LoginRequestMessage("Danny");
        String loginData = login.asString();
        System.out.println(loginData);
        LoginRequestMessage parsedLogin = new LoginRequestMessage();
        parsedLogin.fromString(loginData);
        String parsedLoginData = parsedLogin.getData();
        System.out.println(loginData + " : " + parsedLoginData);
        ArrayList<String> users = new ArrayList<String>();
        users.add("Danny");
        users.add("Jared");
        users.add("Tyrus");
        UserListUpdateMessage userListUpdate = new UserListUpdateMessage(users);
        System.out.println(userListUpdate.asString());
        UserListUpdateMessage parsedUserListUpdate = new UserListUpdateMessage();
        parsedUserListUpdate.fromString(userListUpdate.asString());
        System.out.println(parsedUserListUpdate.asString());
        ArrayList<String> chatNameValue = new ArrayList<String>();
        chatNameValue.add("Danny");
        chatNameValue.add("hi there");
        ChatUpdateMessage cm = new ChatUpdateMessage("Danny", "Hi There");
        System.out.println(cm.asString());
        ChatUpdateMessage parsedCM = new ChatUpdateMessage();
        parsedCM.fromString(cm.asString());
        System.out.println(parsedCM.asString());
    }

    public static ChatMessage parseMessage(String s) {
        LoginRequestMessage chatMessage;
        System.out.println("Parse: " + s);
        if (s.startsWith(LOGIN_REQUEST)) {
            chatMessage = new LoginRequestMessage();
        } else if (s.startsWith(LOGIN_RESPONSE)) {
            chatMessage = new LoginResponseMessage();
        } else if (s.startsWith(DISCONNECT_REQUEST)) {
            chatMessage = new DisconnectRequestMessage();
        } else if (s.startsWith(DISCONNECT_RESPONSE)) {
            chatMessage = new DisconnectResponseMessage();
        } else if (s.startsWith(CHAT_MESSAGE)) {
            chatMessage = new ChatUpdateMessage();
        } else if (s.startsWith(USERLIST_UPDATE)) {
            chatMessage = new UserListUpdateMessage();
        } else if (s.startsWith(CHATTRANSCRIPT_UPDATE)) {
            chatMessage = new ChatTranscriptUpdateMessage();
        } else {
            throw new RuntimeException("Unknown message: " + s);
        }
        chatMessage.fromString(s);
        return chatMessage;
    }

    public abstract String asString();

    public abstract void fromString(String var1);

    ChatMessage(String type) {
        this.type = type;
    }

    abstract Object getData();

    public String getType() {
        return this.type;
    }
}

