/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.sample.draw;

import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.websocket.EncodeException;
import javax.net.websocket.Session;
import javax.net.websocket.annotations.WebSocketClose;
import javax.net.websocket.annotations.WebSocketEndpoint;
import javax.net.websocket.annotations.WebSocketMessage;
import javax.net.websocket.annotations.WebSocketOpen;

@WebSocketEndpoint(value="/draw")
public class GroupDrawServer {
    private Set<Session> peers = Collections.newSetFromMap(new ConcurrentHashMap());

    @WebSocketOpen
    public void onOpen(Session session) {
        this.peers.add(session);
    }

    @WebSocketClose
    public void onClose(Session session) {
        this.peers.remove(session);
    }

    @WebSocketMessage
    public void shapeCreated(String message, Session client) throws IOException, EncodeException {
        System.out.println("Received message: " + message);
        for (Session otherSession : this.peers) {
            if (otherSession.equals(client)) continue;
            otherSession.getRemote().sendString(message);
        }
    }
}

