/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.sample.draw;

import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.websocket.EncodeException;
import javax.websocket.Session;
import javax.websocket.WebSocketClose;
import javax.websocket.WebSocketEndpoint;
import javax.websocket.WebSocketMessage;
import javax.websocket.WebSocketOpen;

@WebSocketEndpoint(value="/draw")
public class GroupDrawServer {
    private Set<Session> peers = Collections.newSetFromMap(new ConcurrentHashMap());

    @WebSocketOpen
    public void onOpen(Session session) {
        this.peers.add(session);
    }

    @WebSocketClose
    public void onClose(Session session) {
        this.peers.remove(session);
    }

    @WebSocketMessage
    public void shapeCreated(String message, Session client) throws IOException, EncodeException {
        System.out.println("Received message: " + message);
        for (Session otherSession : this.peers) {
            if (otherSession.equals(client)) continue;
            otherSession.getRemote().sendString(message);
        }
    }
}

