/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.sample.draw;

import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.websocket.EncodeException;
import javax.websocket.Session;
import javax.websocket.WebSocketClose;
import javax.websocket.WebSocketMessage;
import javax.websocket.WebSocketOpen;
import javax.websocket.server.DefaultServerConfiguration;
import javax.websocket.server.WebSocketEndpoint;

@WebSocketEndpoint(value="/draw", configuration=DefaultServerConfiguration.class)
public class DrawEndpoint {
    private static Set<Session> peers = Collections.newSetFromMap(new ConcurrentHashMap());

    @WebSocketOpen
    public void onOpen(Session session) {
        peers.add(session);
    }

    @WebSocketClose
    public void onClose(Session session) {
        peers.remove(session);
    }

    @WebSocketMessage
    public void shapeCreated(String message, Session client) throws IOException, EncodeException {
        for (Session otherSession : peers) {
            if (otherSession.equals(client)) continue;
            otherSession.getRemote().sendString(message);
        }
    }
}

