/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.sample.draw;

import jakarta.websocket.EncodeException;
import jakarta.websocket.OnClose;
import jakarta.websocket.OnMessage;
import jakarta.websocket.OnOpen;
import jakarta.websocket.Session;
import jakarta.websocket.server.ServerEndpoint;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

@ServerEndpoint(value="/draw")
public class DrawEndpoint {
    private static Set<Session> peers = Collections.newSetFromMap(new ConcurrentHashMap());

    @OnOpen
    public void onOpen(Session session) {
        peers.add(session);
    }

    @OnClose
    public void onClose(Session session) {
        peers.remove(session);
    }

    @OnMessage
    public void shapeCreated(String message, Session client) throws IOException, EncodeException {
        for (Session otherSession : peers) {
            if (otherSession.equals((Object)client)) continue;
            otherSession.getBasicRemote().sendText(message);
        }
    }
}

