/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.sample.shared.collection;

import java.io.IOException;
import java.io.Reader;
import java.util.Deque;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;
import org.glassfish.tyrus.sample.shared.collection.SharedCollectionEndpoint;

@ServerEndpoint(value="/tyrus-collection")
public class SharedCollectionEndpoint {
    private static final Map<String, String> map = new ConcurrentHashMap();
    private static final Deque<Tuple<Session, JsonObject>> broadcastQueue = new ConcurrentLinkedDeque();
    private volatile boolean broadcasting = false;

    @OnOpen
    public void onOpen(Session s) {
        JsonObjectBuilder mapRepresentation = Json.createObjectBuilder();
        for (Map.Entry entry : map.entrySet()) {
            mapRepresentation.add((String)entry.getKey(), (String)entry.getValue());
        }
        JsonObjectBuilder event = Json.createObjectBuilder();
        event.add("event", "init");
        event.add("map", (JsonValue)mapRepresentation.build());
        try {
            s.getBasicRemote().sendText(event.build().toString());
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    @OnMessage
    public void onMessage(Session s, Reader message) {
        String event;
        JsonObject jsonObject = Json.createReader((Reader)message).readObject();
        switch (event = jsonObject.getString("event")) {
            case "put": {
                map.put(jsonObject.getString("key"), jsonObject.getString("value"));
                this.broadcast(s, jsonObject);
                break;
            }
            case "remove": {
                map.remove(jsonObject.getString("key"));
                this.broadcast(s, jsonObject);
                break;
            }
            case "clear": {
                map.clear();
                this.broadcast(s, jsonObject);
            }
        }
    }

    private void broadcast(Session s, JsonObject object) {
        broadcastQueue.add(new Tuple((Object)s, (Object)object, null));
        this.processQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processQueue() {
        if (this.broadcasting) {
            return;
        }
        Deque deque = broadcastQueue;
        synchronized (deque) {
            this.broadcasting = true;
            if (!broadcastQueue.isEmpty()) {
                while (!broadcastQueue.isEmpty()) {
                    Tuple t = (Tuple)broadcastQueue.remove();
                    Session s = (Session)t.first;
                    String message = ((JsonObject)t.second).toString();
                    for (Session session : s.getOpenSessions()) {
                        if (session.getId().equals(s.getId())) continue;
                        try {
                            session.getBasicRemote().sendText(message);
                        }
                        catch (IOException e) {}
                    }
                }
            }
        }
        this.broadcasting = false;
        if (!broadcastQueue.isEmpty()) {
            this.processQueue();
        }
    }

    @OnError
    public void onError(Throwable t) {
        System.out.println("# onError");
        t.printStackTrace();
    }

    static {
        map.put("Red Leader", "Garven Dreis");
        map.put("Red Two", "Wedge Antilles");
        map.put("Red Three", "Biggs Darklighter");
        map.put("Red Four", "John D. Branon");
        map.put("Red Five", "Luke Skywalker");
    }
}

