/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.sample.shared.collection;

import java.io.IOException;
import java.io.Reader;
import java.util.Deque;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedDeque;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;
import org.glassfish.tyrus.sample.shared.collection.SharedCollection;
import org.glassfish.tyrus.sample.shared.collection.SharedCollectionEndpoint;

/*
 * Exception performing whole class analysis ignored.
 */
@ServerEndpoint(value="/ws/collection")
public class SharedCollectionEndpoint {
    private static final Deque<Tuple<Session, JsonObject>> broadcastQueue = new ConcurrentLinkedDeque();
    private static volatile Session session;
    private static volatile boolean broadcasting;

    @OnOpen
    public void onOpen(Session s) {
        session = s;
        JsonObjectBuilder mapRepresentation = Json.createObjectBuilder();
        for (Map.Entry entry : SharedCollection.map.entrySet()) {
            mapRepresentation.add((String)entry.getKey(), (String)entry.getValue());
        }
        JsonObjectBuilder event = Json.createObjectBuilder();
        event.add("event", "init");
        event.add("map", (JsonValue)mapRepresentation.build());
        try {
            s.getBasicRemote().sendText(event.build().toString());
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    @OnMessage
    public void onMessage(Reader message) {
        String event;
        JsonObject jsonObject = Json.createReader((Reader)message).readObject();
        switch (event = jsonObject.getString("event")) {
            case "put": {
                SharedCollection.map.put(jsonObject.getString("key"), jsonObject.getString("value"));
                SharedCollection.broadcast((JsonObject)jsonObject);
                break;
            }
            case "remove": {
                SharedCollection.map.remove(jsonObject.getString("key"));
                SharedCollection.broadcast((JsonObject)jsonObject);
                break;
            }
            case "clear": {
                SharedCollection.map.clear();
                SharedCollection.broadcast((JsonObject)jsonObject);
            }
        }
    }

    static void broadcast(JsonObject object) {
        broadcastQueue.add(new Tuple(null, (Object)object, null));
        SharedCollectionEndpoint.processQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processQueue() {
        if (broadcasting) {
            return;
        }
        try {
            Deque deque = broadcastQueue;
            synchronized (deque) {
                broadcasting = true;
                if (!broadcastQueue.isEmpty()) {
                    while (!broadcastQueue.isEmpty()) {
                        Tuple t = (Tuple)broadcastQueue.remove();
                        Session s = session;
                        String message = ((JsonObject)t.second).toString();
                        for (Session session : s.getOpenSessions()) {
                            try {
                                session.getBasicRemote().sendText(message);
                            }
                            catch (IOException e) {}
                        }
                    }
                }
            }
        }
        finally {
            broadcasting = false;
            if (!broadcastQueue.isEmpty()) {
                SharedCollectionEndpoint.processQueue();
            }
        }
    }

    @OnError
    public void onError(Throwable t) {
        System.out.println("# onError");
        t.printStackTrace();
    }
}

