<%--

    DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.

    Copyright (c) 2011 - 2012 Oracle and/or its affiliates. All rights reserved.

    The contents of this file are subject to the terms of either the GNU
    General Public License Version 2 only ("GPL") or the Common Development
    and Distribution License("CDDL") (collectively, the "License").  You
    may not use this file except in compliance with the License.  You can
    obtain a copy of the License at
    http://glassfish.java.net/public/CDDL+GPL_1_1.html
    or packager/legal/LICENSE.txt.  See the License for the specific
    language governing permissions and limitations under the License.

    When distributing the software, include this License Header Notice in each
    file and include the License file at packager/legal/LICENSE.txt.

    GPL Classpath Exception:
    Oracle designates this particular file as subject to the "Classpath"
    exception as provided by Oracle in the GPL Version 2 section of the License
    file that accompanied this code.

    Modifications:
    If applicable, add the following below the License Header, with the fields
    enclosed by brackets [] replaced by your own identifying information:
    "Portions Copyright [year] [name of copyright owner]"

    Contributor(s):
    If you wish your version of this file to be governed by only the CDDL or
    only the GPL Version 2, indicate your decision by adding "[Contributor]
    elects to include this software in this distribution under the [CDDL or GPL
    Version 2] license."  If you don't indicate a single choice of license, a
    recipient has the option to distribute your version of this file under
    either the CDDL, the GPL Version 2 or to extend the choice of license to
    its licensees as provided above.  However, if you add GPL Version 2 code
    and therefore, elected the GPL Version 2 license, then the option applies
    only if the new code is made subject to such option by the copyright
    holder.

--%>
<%--
    Document   : simplelife
    Created on : Sep 29, 2011, 11:01:23 AM
    Author     : Danny Coward (danny.coward at oracle.com)
--%>

<%@page contentType="text/html" pageEncoding="UTF-8" %>
<!DOCTYPE html>
<html>
<body>
<meta charset="utf-8">
<title>Web Socket JavaScript Simple Life</title>
<script language="javascript" type="text/javascript">
    var wsUri = "ws://localhost:8080/sample-simplelife/simplelife";
    var output;

    function init() {
        output = document.getElementById("output");
    }

    function open_life() {
        websocket = new WebSocket(wsUri);
        websocket.onopen = function (evt) {
            onOpen(evt)
        };
        websocket.onmessage = function (evt) {
            onMessage(evt)
        };
        websocket.onerror = function (evt) {
            onError(evt)
        };
        websocket.onclose = function (evt) {
            onClose(evt)
        };
    }

    function close_life() {
        websocket.close();
    }

    function run_life() {
        if (websocket.readyState == 1) {
            websocket.send("This is your friendly JavaScript page calling");
            writeToScreen("SENT MESSAGE to " + wsUri);
        } else {
            writeToScreen("try reconnecting...");
        }
    }

    function onOpen(evt) {
        writeToScreen("CONNECTED to " + wsUri);
    }

    function onMessage(evt) {
        writeToScreen("RECEIVED: " + evt.data);
    }

    function onError(evt) {
        writeToScreen('<span style="color: red;">ERROR:</span> ' + evt.data);
    }

    function onClose(evt) {
        writeToScreen("DISCONNECTED from " + wsUri);
    }

    function writeToScreen(message) {
        var pre = document.createElement("p");
        pre.style.wordWrap = "break-word";
        pre.innerHTML = message;
        output.appendChild(pre);
    }

    window.addEventListener("load", init, false);

</script>

<h2 style="text-align: center;">Web Socket Simple Life Client</h2>

<div style="text-align: center;"><img style=" width: 64px; height: 64px;" alt="" src="HTML5_Logo_512.png"></div>
<br></br>

<div style="text-align: center;">
    <form action="">
        <input onclick="open_life()" value="Connect" type="button">
        <input onclick="run_life()" value="Send" type="button">
        <input onclick="close_life()" value="Disconnect" type="button">
        <br>
    </form>
</div>
<div style="text-align: center;" id="output"></div>
</body>
</html>
