/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.sample.simplelife;

import jakarta.websocket.OnClose;
import jakarta.websocket.OnMessage;
import jakarta.websocket.OnOpen;
import jakarta.websocket.Session;
import jakarta.websocket.server.ServerEndpoint;
import java.io.IOException;

@ServerEndpoint(value="/simplelife")
public class SimpleLifeEndpoint {
    @OnOpen
    public void hi(Session remote) throws IOException {
        System.out.println("Someone connected...");
        remote.getBasicRemote().sendText("onOpen");
    }

    @OnMessage
    public void handleMessage(String message, Session session) {
        System.out.println("Someone sent me this message: " + message);
        try {
            session.getBasicRemote().sendText(message);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @OnClose
    public void bye(Session remote) {
        System.out.println("Someone is disconnecting...");
    }
}

