/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.plugins.jarupdater;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="update", defaultPhase=LifecyclePhase.VERIFY, threadSafe=true)
public class JarUpdaterMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    MavenProject project;
    @Parameter(property="files")
    List<String> files;
    @Parameter(property="dest")
    String dest;
    @Parameter(property="jar")
    String jar;
    @Parameter(property="ignoreOnError", defaultValue="false")
    String ignoreOnError;
    @Parameter(name="verbose", property="verbose", defaultValue="true")
    String verboseParam;
    @Parameter(property="skip", name="skip")
    String skip;
    File absoluteJar;
    List<File> sources;
    List<Pattern> skipPatterns;
    boolean ignore;
    boolean verbose;

    public void execute() throws MojoExecutionException {
        this.ignore = Boolean.parseBoolean(this.ignoreOnError);
        this.verbose = Boolean.parseBoolean(this.verboseParam);
        try {
            this.prepareSkipPatterns();
            if (!this.skipModule()) {
                this.validateOptions();
                this.updateJar();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MojoExecutionException((Throwable)e);
        }
    }

    private void updateJar() throws IOException, URISyntaxException {
        try (FileSystem fs = FileSystems.newFileSystem(this.absoluteJar.toPath(), (ClassLoader)null);){
            for (File fileToZip : this.sources) {
                if (this.verbose) {
                    System.out.append("Adding ").append(fileToZip.getName()).append(" to ").append(this.absoluteJar.getName()).append('/').println(this.dest);
                }
                Path pathInZipfile = fs.getPath(this.dest + "/" + fileToZip.getName(), new String[0]);
                this.ensureFolder(pathInZipfile);
                Files.copy(fileToZip.toPath(), pathInZipfile, StandardCopyOption.REPLACE_EXISTING);
            }
        }
    }

    private void ensureFolder(Path path) throws IOException {
        if (path.getParent() != null && !Files.exists(path.getParent(), new LinkOption[0])) {
            this.ensureFolder(path.getParent());
            Files.createDirectory(path.getParent(), new FileAttribute[0]);
        }
    }

    private void validateOptions() throws MojoExecutionException, IOException {
        if (this.jar == null) {
            throw new MojoExecutionException("Jar name not defined");
        }
        this.absoluteJar = this.validateJar(this.jar);
        if (this.dest == null || this.dest.isEmpty()) {
            throw new MojoExecutionException("Destination is mandatory");
        }
        if (this.files == null) {
            throw new MojoExecutionException("Files set is required");
        }
        this.sources = new ArrayList<File>(this.files.size());
        for (String file : this.files) {
            this.validateSource(file);
        }
    }

    private void validateSource(String file) throws MojoExecutionException {
        File absolute = this.validateAbsolute(file, this.ignore);
        if (absolute != null) {
            if (!absolute.isDirectory()) {
                this.sources.add(absolute);
            } else {
                JarUpdaterMojo.listAllFiles(absolute.toPath(), this.sources);
            }
        }
    }

    private File validateJar(String source) throws MojoExecutionException {
        File absolute = this.validateAbsolute(source, false);
        if (absolute.isDirectory()) {
            throw new MojoExecutionException("Provided source " + source + " is a directory");
        }
        return absolute;
    }

    private File validateAbsolute(String source, boolean ignore) throws MojoExecutionException {
        File absolute = this.getAbsolute(source);
        if (!absolute.exists()) {
            if (!ignore) {
                throw new MojoExecutionException("Provided source " + source + " does not exist");
            }
            System.out.println("Warning: Ignoring non-existing " + source);
            return null;
        }
        return absolute;
    }

    private File getAbsolute(String sfile) {
        File file = new File(sfile);
        if (!file.isAbsolute()) {
            file = new File(this.project.getBasedir(), sfile);
        }
        return file;
    }

    private void prepareSkipPatterns() {
        if (this.skip != null) {
            String[] skipIdss = this.skip.split(",");
            this.skipPatterns = new ArrayList<Pattern>(skipIdss.length);
            for (String skip : skipIdss) {
                if (skip.isEmpty()) continue;
                String pat = skip.trim().replace(".", "\\.").replace("*", ".*");
                Pattern pattern = Pattern.compile(pat);
                this.skipPatterns.add(pattern);
            }
        } else {
            this.skipPatterns = Collections.emptyList();
        }
    }

    private boolean skipModule() {
        String moduleName = this.project.getGroupId() + ":" + this.project.getArtifactId();
        for (Pattern pattern : this.skipPatterns) {
            Matcher matcher = pattern.matcher(moduleName);
            if (!matcher.matches()) continue;
            System.out.append("Skipping module ").println(moduleName);
            return true;
        }
        return false;
    }

    private static void listAllFiles(Path currentPath, List<File> allFiles) throws MojoExecutionException {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(currentPath);){
            for (Path entry : stream) {
                if (Files.isDirectory(entry, new LinkOption[0])) {
                    JarUpdaterMojo.listAllFiles(entry, allFiles);
                    continue;
                }
                allFiles.add(entry.toFile());
            }
        }
        catch (IOException ioe) {
            throw new MojoExecutionException((Throwable)ioe);
        }
    }
}

