/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.client;

import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import javax.websocket.ClientEndpointConfiguration;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfiguration;
import javax.websocket.Extension;
import javax.websocket.Session;
import javax.websocket.WebSocketClient;
import javax.websocket.WebSocketContainer;
import org.glassfish.tyrus.AnnotatedEndpoint;
import org.glassfish.tyrus.EndpointWrapper;
import org.glassfish.tyrus.ErrorCollector;
import org.glassfish.tyrus.ReflectionHelper;
import org.glassfish.tyrus.TyrusClientEndpointConfiguration;
import org.glassfish.tyrus.TyrusContainerProvider;
import org.glassfish.tyrus.spi.SPIEndpoint;
import org.glassfish.tyrus.spi.TyrusClientSocket;
import org.glassfish.tyrus.spi.TyrusContainer;

public class ClientManager
implements WebSocketContainer {
    private static final String ENGINE_PROVIDER_CLASSNAME = "org.glassfish.tyrus.container.grizzly.GrizzlyEngine";
    private static final Logger LOGGER = Logger.getLogger(ClientManager.class.getName());
    private final Set<TyrusClientSocket> sockets = new HashSet<TyrusClientSocket>();
    private final TyrusContainer engine;
    private long maxSessionIdleTimeout;
    private long maxBinaryMessageBufferSize;
    private long maxTextMessageBufferSize;
    private long defaultAsyncSendTimeout;

    public static ClientManager createClient() {
        return ClientManager.createClient(ENGINE_PROVIDER_CLASSNAME);
    }

    public static ClientManager createClient(String engineProviderClassname) {
        return new ClientManager(engineProviderClassname);
    }

    public ClientManager() {
        this(ENGINE_PROVIDER_CLASSNAME);
    }

    private ClientManager(String engineProviderClassname) {
        try {
            Class engineProviderClazz = ReflectionHelper.classForNameWithException((String)engineProviderClassname);
            LOGGER.config(String.format("Provider class loaded: %s", engineProviderClassname));
            this.engine = (TyrusContainer)engineProviderClazz.newInstance();
            TyrusContainerProvider.getContainerProvider().setContainer((Object)this);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Failed to load provider class: %s.", engineProviderClassname));
        }
    }

    public Session connectToServer(Class annotatedEndpointClass, URI path) throws DeploymentException {
        return this.connectToServer((Object)annotatedEndpointClass, null, path.toString());
    }

    public Session connectToServer(Class<? extends Endpoint> endpointClass, ClientEndpointConfiguration cec, URI path) throws DeploymentException {
        return this.connectToServer(endpointClass, cec, path.toString());
    }

    public Session connectToServer(Object obj, URI path) throws DeploymentException {
        return this.connectToServer(obj, null, path.toString());
    }

    public Session connectToServer(Object obj, ClientEndpointConfiguration cec, URI path) throws DeploymentException {
        return this.connectToServer(obj, cec, path.toString());
    }

    public Set<Session> getOpenSessions() {
        return null;
    }

    Session connectToServer(Object o, ClientEndpointConfiguration configuration, String url) throws DeploymentException {
        ErrorCollector collector = new ErrorCollector();
        TyrusClientSocket clientSocket = null;
        try {
            ClientEndpointConfiguration config;
            Endpoint endpoint;
            if (o instanceof Endpoint) {
                endpoint = (Endpoint)o;
                config = configuration == null ? new TyrusClientEndpointConfiguration.Builder().build() : configuration;
            } else if (o instanceof Class) {
                if (Endpoint.class.isAssignableFrom((Class)o)) {
                    endpoint = (Endpoint)((Class)o).newInstance();
                    config = configuration == null ? new TyrusClientEndpointConfiguration.Builder().build() : configuration;
                } else if (((Class)o).getAnnotation(WebSocketClient.class) != null) {
                    endpoint = AnnotatedEndpoint.fromClass((Class)((Class)o), (boolean)false, (ErrorCollector)collector);
                    config = (ClientEndpointConfiguration)((AnnotatedEndpoint)endpoint).getEndpointConfiguration();
                } else {
                    collector.addException((Exception)new DeploymentException(String.format("Class %s in not Endpoint descendant and does not have @WebSocketAnnotation", ((Class)o).getName())));
                    endpoint = null;
                    config = null;
                }
            } else {
                endpoint = AnnotatedEndpoint.fromInstance((Object)o, (boolean)false, (ErrorCollector)collector);
                config = (ClientEndpointConfiguration)((AnnotatedEndpoint)endpoint).getEndpointConfiguration();
            }
            EndpointWrapper clientEndpoint = new EndpointWrapper(endpoint, (EndpointConfiguration)config, (WebSocketContainer)this, null);
            clientSocket = this.engine.openClientSocket(url, config, (SPIEndpoint)clientEndpoint);
            this.sockets.add(clientSocket);
        }
        catch (Exception e) {
            collector.addException((Exception)new DeploymentException("Connection failed.", (Throwable)e));
        }
        if (!collector.isEmpty()) {
            if (clientSocket != null) {
                this.sockets.remove(clientSocket);
            }
            throw collector.composeComprehensiveException();
        }
        return clientSocket == null ? null : clientSocket.getSession();
    }

    public void close() {
        for (TyrusClientSocket s : this.sockets) {
            s.close();
        }
    }

    public long getMaxSessionIdleTimeout() {
        return this.maxSessionIdleTimeout;
    }

    public void setMaxSessionIdleTimeout(long maxSessionIdleTimeout) {
        this.maxSessionIdleTimeout = maxSessionIdleTimeout;
    }

    public long getMaxBinaryMessageBufferSize() {
        return this.maxBinaryMessageBufferSize;
    }

    public void setMaxBinaryMessageBufferSize(long maxBinaryMessageBufferSize) {
        this.maxBinaryMessageBufferSize = maxBinaryMessageBufferSize;
    }

    public long getMaxTextMessageBufferSize() {
        return this.maxTextMessageBufferSize;
    }

    public void setMaxTextMessageBufferSize(long maxTextMessageBufferSize) {
        this.maxTextMessageBufferSize = maxTextMessageBufferSize;
    }

    public Set<Extension> getInstalledExtensions() {
        return null;
    }

    public long getDefaultAsyncSendTimeout() {
        return this.defaultAsyncSendTimeout;
    }

    public void setAsyncSendTimeout(long timeoutmillis) {
        this.defaultAsyncSendTimeout = timeoutmillis;
    }
}

