/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.client;

import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import javax.websocket.ClientEndpointConfiguration;
import javax.websocket.ContainerProvider;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfiguration;
import javax.websocket.Extension;
import javax.websocket.Session;
import javax.websocket.WebSocketClient;
import javax.websocket.WebSocketContainer;
import org.glassfish.tyrus.AnnotatedEndpoint;
import org.glassfish.tyrus.ComponentProviderService;
import org.glassfish.tyrus.EndpointWrapper;
import org.glassfish.tyrus.ErrorCollector;
import org.glassfish.tyrus.ReflectionHelper;
import org.glassfish.tyrus.TyrusClientEndpointConfiguration;
import org.glassfish.tyrus.TyrusContainerProvider;
import org.glassfish.tyrus.spi.SPIEndpoint;
import org.glassfish.tyrus.spi.TyrusClientSocket;
import org.glassfish.tyrus.spi.TyrusContainer;

public class ClientManager
extends ContainerProvider
implements WebSocketContainer {
    private static final String ENGINE_PROVIDER_CLASSNAME = "org.glassfish.tyrus.container.grizzly.GrizzlyEngine";
    private static final Logger LOGGER = Logger.getLogger(ClientManager.class.getName());
    private final Set<TyrusClientSocket> sockets = new HashSet<TyrusClientSocket>();
    private final TyrusContainer engine;
    private final ComponentProviderService componentProvider;
    private final ErrorCollector collector = new ErrorCollector();
    private long maxSessionIdleTimeout;
    private long defaultAsyncSendTimeout;
    private int maxBinaryMessageBufferSize;
    private int maxTextMessageBufferSize;

    public static ClientManager createClient() {
        return ClientManager.createClient(ENGINE_PROVIDER_CLASSNAME);
    }

    public static ClientManager createClient(String engineProviderClassname) {
        return new ClientManager(engineProviderClassname);
    }

    protected <T> T getContainer(Class<T> tClass) {
        if (tClass.equals(WebSocketContainer.class)) {
            return (T)((Object)new ClientManager());
        }
        return null;
    }

    public ClientManager() {
        this(ENGINE_PROVIDER_CLASSNAME);
    }

    private ClientManager(String engineProviderClassname) {
        this.componentProvider = ComponentProviderService.create((ErrorCollector)this.collector);
        Class engineProviderClazz = null;
        try {
            engineProviderClazz = ReflectionHelper.classForNameWithException((String)engineProviderClassname);
        }
        catch (ClassNotFoundException e) {
            this.collector.addException((Exception)e);
        }
        LOGGER.config(String.format("Provider class loaded: %s", engineProviderClassname));
        this.engine = (TyrusContainer)ReflectionHelper.getInstance((Class)engineProviderClazz, (ErrorCollector)this.collector);
        TyrusContainerProvider.getContainerProvider().setContainer((Object)this);
        if (!this.collector.isEmpty()) {
            throw new RuntimeException((Throwable)this.collector.composeComprehensiveException());
        }
    }

    public Session connectToServer(Class annotatedEndpointClass, URI path) throws DeploymentException {
        return this.connectToServer((Object)annotatedEndpointClass, null, path.toString());
    }

    public Session connectToServer(Class<? extends Endpoint> endpointClass, ClientEndpointConfiguration cec, URI path) throws DeploymentException {
        return this.connectToServer(endpointClass, cec, path.toString());
    }

    public Session connectToServer(Object obj, URI path) throws DeploymentException {
        return this.connectToServer(obj, null, path.toString());
    }

    public Session connectToServer(Object obj, ClientEndpointConfiguration cec, URI path) throws DeploymentException {
        return this.connectToServer(obj, cec, path.toString());
    }

    Session connectToServer(Object o, ClientEndpointConfiguration configuration, String url) throws DeploymentException {
        TyrusClientSocket clientSocket = null;
        try {
            ClientEndpointConfiguration config;
            Endpoint endpoint;
            if (o instanceof Endpoint) {
                endpoint = (Endpoint)o;
                config = configuration == null ? new TyrusClientEndpointConfiguration.Builder().build() : configuration;
            } else if (o instanceof Class) {
                if (Endpoint.class.isAssignableFrom((Class)o)) {
                    endpoint = (Endpoint)ReflectionHelper.getInstance((Class)((Class)o), (ErrorCollector)this.collector);
                    config = configuration == null ? new TyrusClientEndpointConfiguration.Builder().build() : configuration;
                } else if (((Class)o).getAnnotation(WebSocketClient.class) != null) {
                    endpoint = AnnotatedEndpoint.fromClass((Class)((Class)o), (ComponentProviderService)this.componentProvider, (boolean)false, (ErrorCollector)this.collector);
                    config = (ClientEndpointConfiguration)((AnnotatedEndpoint)endpoint).getEndpointConfiguration();
                } else {
                    this.collector.addException((Exception)new DeploymentException(String.format("Class %s in not Endpoint descendant and does not have @WebSocketClient", ((Class)o).getName())));
                    endpoint = null;
                    config = null;
                }
            } else {
                endpoint = AnnotatedEndpoint.fromInstance((Object)o, (ComponentProviderService)this.componentProvider, (boolean)false, (ErrorCollector)this.collector);
                config = (ClientEndpointConfiguration)((AnnotatedEndpoint)endpoint).getEndpointConfiguration();
            }
            if (endpoint != null) {
                EndpointWrapper clientEndpoint = new EndpointWrapper(endpoint, (EndpointConfiguration)config, this.componentProvider, (WebSocketContainer)this, null, this.collector);
                clientSocket = this.engine.openClientSocket(url, config, (SPIEndpoint)clientEndpoint);
                this.sockets.add(clientSocket);
            }
        }
        catch (Exception e) {
            this.collector.addException((Exception)new DeploymentException("Connection failed.", (Throwable)e));
        }
        if (!this.collector.isEmpty()) {
            if (clientSocket != null) {
                this.sockets.remove(clientSocket);
            }
            throw this.collector.composeComprehensiveException();
        }
        return clientSocket == null ? null : clientSocket.getSession();
    }

    public void close() {
        for (TyrusClientSocket s : this.sockets) {
            s.close();
        }
    }

    public long getMaxSessionIdleTimeout() {
        return this.maxSessionIdleTimeout;
    }

    public void setMaxSessionIdleTimeout(long maxSessionIdleTimeout) {
        this.maxSessionIdleTimeout = maxSessionIdleTimeout;
    }

    public int getDefaultMaxBinaryMessageBufferSize() {
        return this.maxBinaryMessageBufferSize;
    }

    public void setDefaultMaxBinaryMessageBufferSize(int i) {
        this.maxBinaryMessageBufferSize = i;
    }

    public int getDefaultMaxTextMessageBufferSize() {
        return this.maxTextMessageBufferSize;
    }

    public void setDefaultMaxTextMessageBufferSize(int i) {
        this.maxTextMessageBufferSize = i;
    }

    public Set<Extension> getInstalledExtensions() {
        return null;
    }

    public long getDefaultAsyncSendTimeout() {
        return this.defaultAsyncSendTimeout;
    }

    public void setAsyncSendTimeout(long timeoutmillis) {
        this.defaultAsyncSendTimeout = timeoutmillis;
    }
}

