/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.client;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.websocket.ClientEndpoint;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.Extension;
import javax.websocket.HandshakeResponse;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;
import org.glassfish.tyrus.core.AnnotatedEndpoint;
import org.glassfish.tyrus.core.BaseContainer;
import org.glassfish.tyrus.core.ComponentProviderService;
import org.glassfish.tyrus.core.ErrorCollector;
import org.glassfish.tyrus.core.ReflectionHelper;
import org.glassfish.tyrus.core.TyrusEndpointWrapper;
import org.glassfish.tyrus.core.TyrusFuture;
import org.glassfish.tyrus.spi.ClientContainer;
import org.glassfish.tyrus.spi.ClientSocket;
import org.glassfish.tyrus.spi.EndpointWrapper;
import org.glassfish.tyrus.spi.UpgradeResponse;

public class ClientManager
extends BaseContainer
implements WebSocketContainer {
    private static final String CONTAINER_PROVIDER_CLASSNAME = "org.glassfish.tyrus.container.grizzly.client.GrizzlyClientContainer";
    private static final Logger LOGGER = Logger.getLogger(ClientManager.class.getName());
    private final WebSocketContainer webSocketContainer;
    private final ClientContainer container;
    private final ComponentProviderService componentProvider;
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private long defaultAsyncSendTimeout;
    private long defaultMaxSessionIdleTimeout;
    private int maxBinaryMessageBufferSize = Integer.MAX_VALUE;
    private int maxTextMessageBufferSize = Integer.MAX_VALUE;

    public static ClientManager createClient() {
        return ClientManager.createClient(CONTAINER_PROVIDER_CLASSNAME);
    }

    public static ClientManager createClient(WebSocketContainer webSocketContainer) {
        return ClientManager.createClient(CONTAINER_PROVIDER_CLASSNAME, webSocketContainer);
    }

    public static ClientManager createClient(String containerProviderClassName) {
        return new ClientManager(containerProviderClassName, null);
    }

    public static ClientManager createClient(String containerProviderClassName, WebSocketContainer webSocketContainer) {
        return new ClientManager(containerProviderClassName, webSocketContainer);
    }

    public ClientManager() {
        this(CONTAINER_PROVIDER_CLASSNAME, null);
    }

    private ClientManager(String containerProviderClassName, WebSocketContainer webSocketContainer) {
        Class engineProviderClazz;
        ErrorCollector collector = new ErrorCollector();
        this.componentProvider = ComponentProviderService.create();
        try {
            engineProviderClazz = ReflectionHelper.classForNameWithException((String)containerProviderClassName);
        }
        catch (ClassNotFoundException e) {
            collector.addException((Exception)e);
            throw new RuntimeException(collector.composeComprehensiveException());
        }
        LOGGER.config(String.format("Provider class loaded: %s", containerProviderClassName));
        this.container = (ClientContainer)ReflectionHelper.getInstance((Class)engineProviderClazz, (ErrorCollector)collector);
        if (!collector.isEmpty()) {
            throw new RuntimeException(collector.composeComprehensiveException());
        }
        this.webSocketContainer = webSocketContainer;
    }

    public Session connectToServer(Class annotatedEndpointClass, URI path) throws DeploymentException, IOException {
        if (annotatedEndpointClass.getAnnotation(ClientEndpoint.class) == null) {
            throw new DeploymentException(String.format("Class argument in connectToServer(Class, URI) is to be annotated endpoint class.Class %s does not have @ClientEndpoint", annotatedEndpointClass.getName()));
        }
        try {
            return this.connectToServer(annotatedEndpointClass, null, path.toString(), new SameThreadExecutorService()).get();
        }
        catch (InterruptedException e) {
            throw new DeploymentException(e.getMessage(), (Throwable)e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof DeploymentException) {
                throw (DeploymentException)cause;
            }
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new DeploymentException(cause.getMessage(), cause);
        }
    }

    public Session connectToServer(Class<? extends Endpoint> endpointClass, ClientEndpointConfig cec, URI path) throws DeploymentException, IOException {
        try {
            return this.connectToServer(endpointClass, cec, path.toString(), new SameThreadExecutorService()).get();
        }
        catch (InterruptedException e) {
            throw new DeploymentException(e.getMessage(), (Throwable)e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof DeploymentException) {
                throw (DeploymentException)cause;
            }
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new DeploymentException(cause.getMessage(), cause);
        }
    }

    public Session connectToServer(Endpoint endpointInstance, ClientEndpointConfig cec, URI path) throws DeploymentException, IOException {
        try {
            return this.connectToServer(endpointInstance, cec, path.toString(), new SameThreadExecutorService()).get();
        }
        catch (InterruptedException e) {
            throw new DeploymentException(e.getMessage(), (Throwable)e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof DeploymentException) {
                throw (DeploymentException)cause;
            }
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new DeploymentException(cause.getMessage(), cause);
        }
    }

    public Session connectToServer(Object obj, URI path) throws DeploymentException, IOException {
        try {
            return this.connectToServer(obj, null, path.toString(), new SameThreadExecutorService()).get();
        }
        catch (InterruptedException e) {
            throw new DeploymentException(e.getMessage(), (Throwable)e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof DeploymentException) {
                throw (DeploymentException)cause;
            }
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new DeploymentException(cause.getMessage(), cause);
        }
    }

    public Future<Session> asyncConnectToServer(Class<?> annotatedEndpointClass, URI path) throws DeploymentException {
        if (annotatedEndpointClass.getAnnotation(ClientEndpoint.class) == null) {
            throw new DeploymentException(String.format("Class argument in connectToServer(Class, URI) is to be annotated endpoint class.Class %s does not have @ClientEndpoint", annotatedEndpointClass.getName()));
        }
        return this.connectToServer(annotatedEndpointClass, null, path.toString(), this.getExecutorService());
    }

    public Future<Session> asyncConnectToServer(Class<? extends Endpoint> endpointClass, ClientEndpointConfig cec, URI path) throws DeploymentException {
        return this.connectToServer(endpointClass, cec, path.toString(), this.getExecutorService());
    }

    public Future<Session> asyncConnectToServer(Endpoint endpointInstance, ClientEndpointConfig cec, URI path) throws DeploymentException {
        return this.connectToServer(endpointInstance, cec, path.toString(), this.getExecutorService());
    }

    public Future<Session> asyncConnectToServer(Object obj, URI path) throws DeploymentException {
        return this.connectToServer(obj, null, path.toString(), this.getExecutorService());
    }

    Future<Session> connectToServer(final Object o, final ClientEndpointConfig configuration, final String url, ExecutorService executorService) throws DeploymentException {
        final TyrusFuture future = new TyrusFuture();
        try {
            URI uri = new URI(url);
            String scheme = uri.getScheme();
            if (scheme == null || !scheme.equals("ws") && !scheme.equals("wss")) {
                throw new DeploymentException("Incorrect scheme in WebSocket endpoint URI=" + url);
            }
        }
        catch (URISyntaxException e) {
            throw new DeploymentException("Incorrect WebSocket endpoint URI=" + url, (Throwable)e);
        }
        executorService.submit(new Runnable(){

            @Override
            public void run() {
                ClientEndpointConfig config = null;
                ClientSocket clientSocket = null;
                ErrorCollector collector = new ErrorCollector();
                final CountDownLatch responseLatch = new CountDownLatch(1);
                try {
                    Endpoint endpoint;
                    if (o instanceof Endpoint) {
                        endpoint = (Endpoint)o;
                        config = configuration == null ? ClientEndpointConfig.Builder.create().build() : configuration;
                    } else if (o instanceof Class) {
                        if (Endpoint.class.isAssignableFrom((Class)o)) {
                            endpoint = (Endpoint)ReflectionHelper.getInstance((Class)((Class)o), (ErrorCollector)collector);
                            config = configuration == null ? ClientEndpointConfig.Builder.create().build() : configuration;
                        } else if (((Class)o).getAnnotation(ClientEndpoint.class) != null) {
                            endpoint = AnnotatedEndpoint.fromClass((Class)((Class)o), (ComponentProviderService)ClientManager.this.componentProvider, (boolean)false, (ErrorCollector)collector);
                            config = (ClientEndpointConfig)((AnnotatedEndpoint)endpoint).getEndpointConfig();
                        } else {
                            collector.addException((Exception)((Object)new DeploymentException(String.format("Class %s in not Endpoint descendant and does not have @ClientEndpoint", ((Class)o).getName()))));
                            endpoint = null;
                            config = null;
                        }
                    } else {
                        endpoint = AnnotatedEndpoint.fromInstance((Object)o, (ComponentProviderService)ClientManager.this.componentProvider, (boolean)false, (ErrorCollector)collector);
                        config = (ClientEndpointConfig)((AnnotatedEndpoint)endpoint).getEndpointConfig();
                    }
                    final ClientEndpointConfig finalConfig = config;
                    if (endpoint != null) {
                        TyrusEndpointWrapper clientEndpoint = new TyrusEndpointWrapper(endpoint, (EndpointConfig)config, ClientManager.this.componentProvider, (WebSocketContainer)(ClientManager.this.webSocketContainer == null ? ClientManager.this : ClientManager.this.webSocketContainer), url, null);
                        if (!collector.isEmpty()) {
                            future.setFailure((Throwable)collector.composeComprehensiveException());
                            return;
                        }
                        ClientContainer.ClientHandshakeListener listener = new ClientContainer.ClientHandshakeListener(){

                            public void onHandshakeResponse(UpgradeResponse handshakeResponse) {
                                finalConfig.getConfigurator().afterResponse((HandshakeResponse)handshakeResponse);
                                responseLatch.countDown();
                            }

                            public void onError(Throwable exception) {
                                finalConfig.getUserProperties().put("org.glassfish.tyrus.client.exception", exception);
                                responseLatch.countDown();
                            }
                        };
                        clientSocket = ClientManager.this.container.openClientSocket(url, config, (EndpointWrapper)clientEndpoint, listener, ClientManager.this.properties);
                    }
                }
                catch (IOException e) {
                    future.setFailure((Throwable)e);
                    return;
                }
                catch (DeploymentException e) {
                    collector.addException((Exception)((Object)new DeploymentException("Connection failed.", (Throwable)e)));
                }
                if (!collector.isEmpty()) {
                    future.setFailure((Throwable)collector.composeComprehensiveException());
                    return;
                }
                if (clientSocket != null) {
                    try {
                        boolean countedDown = responseLatch.await(10L, TimeUnit.SECONDS);
                        if (countedDown) {
                            Session session;
                            Object exception = config.getUserProperties().get("org.glassfish.tyrus.client.exception");
                            if (exception != null) {
                                future.setFailure((Throwable)new DeploymentException("Handshake error.", (Throwable)exception));
                            }
                            if ((session = clientSocket.getSession()).isOpen()) {
                                session.setMaxBinaryMessageBufferSize(ClientManager.this.maxBinaryMessageBufferSize);
                                session.setMaxTextMessageBufferSize(ClientManager.this.maxTextMessageBufferSize);
                                session.setMaxIdleTimeout(ClientManager.this.defaultMaxSessionIdleTimeout);
                            }
                            future.setResult((Object)session);
                            return;
                        }
                    }
                    catch (InterruptedException e) {
                        future.setFailure((Throwable)new DeploymentException("Handshake response not received.", (Throwable)e));
                    }
                }
                future.setFailure((Throwable)new DeploymentException("Handshake response not received."));
            }
        });
        return future;
    }

    public int getDefaultMaxBinaryMessageBufferSize() {
        if (this.webSocketContainer == null) {
            return this.maxBinaryMessageBufferSize;
        }
        return this.webSocketContainer.getDefaultMaxBinaryMessageBufferSize();
    }

    public void setDefaultMaxBinaryMessageBufferSize(int i) {
        if (this.webSocketContainer == null) {
            this.maxBinaryMessageBufferSize = i;
        } else {
            this.webSocketContainer.setDefaultMaxBinaryMessageBufferSize(i);
        }
    }

    public int getDefaultMaxTextMessageBufferSize() {
        if (this.webSocketContainer == null) {
            return this.maxTextMessageBufferSize;
        }
        return this.webSocketContainer.getDefaultMaxTextMessageBufferSize();
    }

    public void setDefaultMaxTextMessageBufferSize(int i) {
        if (this.webSocketContainer == null) {
            this.maxTextMessageBufferSize = i;
        } else {
            this.webSocketContainer.setDefaultMaxTextMessageBufferSize(i);
        }
    }

    public Set<Extension> getInstalledExtensions() {
        if (this.webSocketContainer == null) {
            return Collections.emptySet();
        }
        return this.webSocketContainer.getInstalledExtensions();
    }

    public long getDefaultAsyncSendTimeout() {
        if (this.webSocketContainer == null) {
            return this.defaultAsyncSendTimeout;
        }
        return this.webSocketContainer.getDefaultAsyncSendTimeout();
    }

    public void setAsyncSendTimeout(long timeoutmillis) {
        if (this.webSocketContainer == null) {
            this.defaultAsyncSendTimeout = timeoutmillis;
        } else {
            this.webSocketContainer.setAsyncSendTimeout(timeoutmillis);
        }
    }

    public long getDefaultMaxSessionIdleTimeout() {
        if (this.webSocketContainer == null) {
            return this.defaultMaxSessionIdleTimeout;
        }
        return this.webSocketContainer.getDefaultMaxSessionIdleTimeout();
    }

    public void setDefaultMaxSessionIdleTimeout(long defaultMaxSessionIdleTimeout) {
        if (this.webSocketContainer == null) {
            this.defaultMaxSessionIdleTimeout = defaultMaxSessionIdleTimeout;
        } else {
            this.webSocketContainer.setDefaultMaxSessionIdleTimeout(defaultMaxSessionIdleTimeout);
        }
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    private static class SameThreadExecutorService
    extends AbstractExecutorService {
        private SameThreadExecutorService() {
        }

        @Override
        public void shutdown() {
        }

        @Override
        public List<Runnable> shutdownNow() {
            return null;
        }

        @Override
        public boolean isShutdown() {
            return false;
        }

        @Override
        public boolean isTerminated() {
            return false;
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return false;
        }

        @Override
        public void execute(Runnable command) {
            command.run();
        }
    }
}

