/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.client;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import javax.websocket.ClientEndpoint;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.CloseReason;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.Extension;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;
import org.glassfish.tyrus.client.RetryAfterException;
import org.glassfish.tyrus.client.TyrusClientEngine;
import org.glassfish.tyrus.core.AnnotatedEndpoint;
import org.glassfish.tyrus.core.BaseContainer;
import org.glassfish.tyrus.core.ComponentProviderService;
import org.glassfish.tyrus.core.ErrorCollector;
import org.glassfish.tyrus.core.ReflectionHelper;
import org.glassfish.tyrus.core.TyrusEndpointWrapper;
import org.glassfish.tyrus.core.TyrusFuture;
import org.glassfish.tyrus.core.TyrusSession;
import org.glassfish.tyrus.core.Utils;
import org.glassfish.tyrus.core.monitoring.EndpointEventListener;
import org.glassfish.tyrus.spi.ClientContainer;
import org.glassfish.tyrus.spi.ClientEngine;

public class ClientManager
extends BaseContainer
implements WebSocketContainer {
    public static final String HANDSHAKE_TIMEOUT = "org.glassfish.tyrus.client.ClientManager.ContainerTimeout";
    public static final String RECONNECT_HANDLER = "org.glassfish.tyrus.client.ClientManager.ReconnectHandler";
    public static final String PROXY_URI = "org.glassfish.tyrus.client.proxy";
    public static final String PROXY_HEADERS = "org.glassfish.tyrus.client.proxy.headers";
    public static final String SSL_ENGINE_CONFIGURATOR = "org.glassfish.tyrus.client.sslEngineConfigurator";
    private static final String CONTAINER_PROVIDER_CLASSNAME = "org.glassfish.tyrus.container.grizzly.client.GrizzlyClientContainer";
    public static final String WLS_PROXY_HOST = "weblogic.websocket.client.PROXY_HOST";
    public static final String WLS_PROXY_PORT = "weblogic.websocket.client.PROXY_PORT";
    public static final String WLS_PROXY_USERNAME = "weblogic.websocket.client.PROXY_USERNAME";
    public static final String WLS_PROXY_PASSWORD = "weblogic.websocket.client.PROXY_PASSWORD";
    public static final String WLS_SSL_PROTOCOLS_PROPERTY = "weblogic.websocket.client.SSL_PROTOCOLS";
    public static final String WLS_SSL_TRUSTSTORE_PROPERTY = "weblogic.websocket.client.SSL_TRUSTSTORE";
    public static final String WLS_SSL_TRUSTSTORE_PWD_PROPERTY = "weblogic.websocket.client.SSL_TRUSTSTORE_PWD";
    public static final String WLS_MAX_THREADS = "weblogic.websocket.client.max-aio-threads";
    private static final Logger LOGGER = Logger.getLogger(ClientManager.class.getName());
    private final WebSocketContainer webSocketContainer;
    private final ClientContainer container;
    private final ComponentProviderService componentProvider;
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private volatile long defaultAsyncSendTimeout;
    private volatile long defaultMaxSessionIdleTimeout;
    private volatile int maxBinaryMessageBufferSize = Integer.MAX_VALUE;
    private volatile int maxTextMessageBufferSize = Integer.MAX_VALUE;

    public static ClientManager createClient() {
        return ClientManager.createClient(CONTAINER_PROVIDER_CLASSNAME);
    }

    public static ClientManager createClient(WebSocketContainer webSocketContainer) {
        return ClientManager.createClient(CONTAINER_PROVIDER_CLASSNAME, webSocketContainer);
    }

    public static ClientManager createClient(String containerProviderClassName) {
        return new ClientManager(containerProviderClassName, null);
    }

    public static ClientManager createClient(String containerProviderClassName, WebSocketContainer webSocketContainer) {
        return new ClientManager(containerProviderClassName, webSocketContainer);
    }

    public ClientManager() {
        this(CONTAINER_PROVIDER_CLASSNAME, null);
    }

    private ClientManager(String containerProviderClassName, WebSocketContainer webSocketContainer) {
        Class engineProviderClazz;
        ErrorCollector collector = new ErrorCollector();
        this.componentProvider = ComponentProviderService.createClient();
        try {
            engineProviderClazz = ReflectionHelper.classForNameWithException((String)containerProviderClassName);
        }
        catch (ClassNotFoundException e) {
            collector.addException((Exception)e);
            throw new RuntimeException(collector.composeComprehensiveException());
        }
        LOGGER.config(String.format("Provider class loaded: %s", containerProviderClassName));
        this.container = (ClientContainer)ReflectionHelper.getInstance((Class)engineProviderClazz, (ErrorCollector)collector);
        if (!collector.isEmpty()) {
            throw new RuntimeException(collector.composeComprehensiveException());
        }
        this.webSocketContainer = webSocketContainer;
    }

    public Session connectToServer(Class annotatedEndpointClass, URI path) throws DeploymentException, IOException {
        if (annotatedEndpointClass.getAnnotation(ClientEndpoint.class) == null) {
            throw new DeploymentException(String.format("Class argument in connectToServer(Class, URI) is to be annotated endpoint class.Class %s does not have @ClientEndpoint", annotatedEndpointClass.getName()));
        }
        try {
            return this.connectToServer(annotatedEndpointClass, null, path.toString(), new SameThreadExecutorService()).get();
        }
        catch (InterruptedException e) {
            throw new DeploymentException(e.getMessage(), (Throwable)e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof DeploymentException) {
                throw (DeploymentException)cause;
            }
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new DeploymentException(cause.getMessage(), cause);
        }
    }

    public Session connectToServer(Class<? extends Endpoint> endpointClass, ClientEndpointConfig cec, URI path) throws DeploymentException, IOException {
        try {
            return this.connectToServer(endpointClass, cec, path.toString(), new SameThreadExecutorService()).get();
        }
        catch (InterruptedException e) {
            throw new DeploymentException(e.getMessage(), (Throwable)e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof DeploymentException) {
                throw (DeploymentException)cause;
            }
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new DeploymentException(cause.getMessage(), cause);
        }
    }

    public Session connectToServer(Endpoint endpointInstance, ClientEndpointConfig cec, URI path) throws DeploymentException, IOException {
        try {
            return this.connectToServer(endpointInstance, cec, path.toString(), new SameThreadExecutorService()).get();
        }
        catch (InterruptedException e) {
            throw new DeploymentException(e.getMessage(), (Throwable)e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof DeploymentException) {
                throw (DeploymentException)cause;
            }
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new DeploymentException(cause.getMessage(), cause);
        }
    }

    public Session connectToServer(Object obj, URI path) throws DeploymentException, IOException {
        try {
            return this.connectToServer(obj, null, path.toString(), new SameThreadExecutorService()).get();
        }
        catch (InterruptedException e) {
            throw new DeploymentException(e.getMessage(), (Throwable)e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof DeploymentException) {
                throw (DeploymentException)cause;
            }
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new DeploymentException(cause.getMessage(), cause);
        }
    }

    public Future<Session> asyncConnectToServer(Class<?> annotatedEndpointClass, URI path) throws DeploymentException {
        if (annotatedEndpointClass.getAnnotation(ClientEndpoint.class) == null) {
            throw new DeploymentException(String.format("Class argument in connectToServer(Class, URI) is to be annotated endpoint class.Class %s does not have @ClientEndpoint", annotatedEndpointClass.getName()));
        }
        return this.connectToServer(annotatedEndpointClass, null, path.toString(), this.getExecutorService());
    }

    public Future<Session> asyncConnectToServer(Class<? extends Endpoint> endpointClass, ClientEndpointConfig cec, URI path) throws DeploymentException {
        return this.connectToServer(endpointClass, cec, path.toString(), this.getExecutorService());
    }

    public Future<Session> asyncConnectToServer(Endpoint endpointInstance, ClientEndpointConfig cec, URI path) throws DeploymentException {
        return this.connectToServer(endpointInstance, cec, path.toString(), this.getExecutorService());
    }

    public Future<Session> asyncConnectToServer(Object obj, URI path) throws DeploymentException {
        return this.connectToServer(obj, null, path.toString(), this.getExecutorService());
    }

    Future<Session> connectToServer(final Object o, final ClientEndpointConfig configuration, final String url, ExecutorService executorService) throws DeploymentException {
        final HashMap<String, Object> copiedProperties = new HashMap<String, Object>(this.properties);
        final TyrusFuture future = new TyrusFuture();
        try {
            URI uri = new URI(url);
            String scheme = uri.getScheme();
            if (scheme == null || !scheme.equals("ws") && !scheme.equals("wss")) {
                throw new DeploymentException("Incorrect scheme in WebSocket endpoint URI=" + url);
            }
        }
        catch (URISyntaxException e) {
            throw new DeploymentException("Incorrect WebSocket endpoint URI=" + url, (Throwable)e);
        }
        final int handshakeTimeout = this.getHandshakeTimeout();
        executorService.submit(new Runnable(){

            @Override
            public void run() {
                ClientEndpointConfig config;
                Endpoint endpoint;
                Integer wlsIncomingBufferSize;
                ErrorCollector collector = new ErrorCollector();
                Integer tyrusIncomingBufferSize = (Integer)Utils.getProperty((Map)copiedProperties, (String)"org.glassfish.tyrus.incomingBufferSize", Integer.class);
                Integer n = wlsIncomingBufferSize = configuration == null ? null : (Integer)Utils.getProperty((Map)configuration.getUserProperties(), (String)"weblogic.websocket.tyrus.incoming-buffer-size", Integer.class);
                int incomingBufferSize = tyrusIncomingBufferSize == null && wlsIncomingBufferSize == null ? 0x40000B : (wlsIncomingBufferSize != null ? wlsIncomingBufferSize.intValue() : tyrusIncomingBufferSize.intValue());
                try {
                    if (o instanceof Endpoint) {
                        endpoint = (Endpoint)o;
                        config = configuration == null ? ClientEndpointConfig.Builder.create().build() : configuration;
                    } else if (o instanceof Class) {
                        if (Endpoint.class.isAssignableFrom((Class)o)) {
                            endpoint = (Endpoint)ReflectionHelper.getInstance((Class)((Class)o), (ErrorCollector)collector);
                            config = configuration == null ? ClientEndpointConfig.Builder.create().build() : configuration;
                        } else if (((Class)o).getAnnotation(ClientEndpoint.class) != null) {
                            endpoint = AnnotatedEndpoint.fromClass((Class)((Class)o), (ComponentProviderService)ClientManager.this.componentProvider, (boolean)false, (int)incomingBufferSize, (ErrorCollector)collector, (EndpointEventListener)EndpointEventListener.NO_OP);
                            config = (ClientEndpointConfig)((AnnotatedEndpoint)endpoint).getEndpointConfig();
                        } else {
                            collector.addException((Exception)((Object)new DeploymentException(String.format("Class %s in not Endpoint descendant and does not have @ClientEndpoint", ((Class)o).getName()))));
                            endpoint = null;
                            config = null;
                        }
                    } else {
                        endpoint = AnnotatedEndpoint.fromInstance((Object)o, (ComponentProviderService)ClientManager.this.componentProvider, (boolean)false, (int)incomingBufferSize, (ErrorCollector)collector);
                        config = (ClientEndpointConfig)((AnnotatedEndpoint)endpoint).getEndpointConfig();
                    }
                    if (!collector.isEmpty()) {
                        future.setFailure((Throwable)collector.composeComprehensiveException());
                        return;
                    }
                }
                catch (Exception e) {
                    future.setFailure((Throwable)e);
                    return;
                }
                final boolean retryAfterEnabled = (Boolean)Utils.getProperty((Map)copiedProperties, (String)"org.glassfish.tyrus.client.http.retryAfter", Boolean.class, (Object)false);
                final ReconnectHandler userReconnectHandler = (ReconnectHandler)Utils.getProperty((Map)copiedProperties, (String)ClientManager.RECONNECT_HANDLER, ReconnectHandler.class);
                Runnable connector = new Runnable(){
                    private final ReconnectHandler reconnectHandler;
                    {
                        this.reconnectHandler = retryAfterEnabled ? new RetryAfterReconnectHandler(userReconnectHandler) : userReconnectHandler;
                    }

                    @Override
                    public void run() {
                        while (true) {
                            final CountDownLatch responseLatch = new CountDownLatch(1);
                            ClientManagerHandshakeListener listener = new ClientManagerHandshakeListener(){
                                private volatile Session session;
                                private volatile Throwable throwable;

                                @Override
                                public void onSessionCreated(Session session) {
                                    this.session = session;
                                    responseLatch.countDown();
                                }

                                @Override
                                public void onError(Throwable exception) {
                                    this.throwable = exception;
                                    responseLatch.countDown();
                                }

                                @Override
                                public Session getSession() {
                                    return this.session;
                                }

                                @Override
                                public Throwable getThrowable() {
                                    return this.throwable;
                                }
                            };
                            try {
                                URI uri;
                                final 1 that = this;
                                TyrusEndpointWrapper clientEndpoint = new TyrusEndpointWrapper(endpoint, (EndpointConfig)config, ClientManager.this.componentProvider, (WebSocketContainer)(ClientManager.this.webSocketContainer == null ? ClientManager.this : ClientManager.this.webSocketContainer), url, null, new TyrusEndpointWrapper.SessionListener(){

                                    public void onClose(TyrusSession session, CloseReason closeReason) {
                                        if (reconnectHandler != null && reconnectHandler.onDisconnect(closeReason)) {
                                            long delay = reconnectHandler.getDelay();
                                            if (delay <= 0L) {
                                                this.run();
                                            } else {
                                                ClientManager.this.getScheduledExecutorService().schedule(that, delay, TimeUnit.SECONDS);
                                            }
                                        }
                                    }
                                }, null, null);
                                try {
                                    uri = new URI(url);
                                }
                                catch (URISyntaxException e) {
                                    throw new DeploymentException("Invalid URI.", (Throwable)e);
                                }
                                TyrusClientEngine clientEngine = new TyrusClientEngine(clientEndpoint, listener, copiedProperties, uri);
                                ClientManager.this.container.openClientSocket(config, copiedProperties, (ClientEngine)clientEngine);
                                try {
                                    boolean countedDown = responseLatch.await(handshakeTimeout, TimeUnit.MILLISECONDS);
                                    if (countedDown) {
                                        Throwable exception = listener.getThrowable();
                                        if (exception != null) {
                                            if (exception instanceof DeploymentException) {
                                                throw (DeploymentException)exception;
                                            }
                                            throw new DeploymentException("Handshake error.", exception);
                                        }
                                        future.setResult((Object)listener.getSession());
                                        return;
                                    }
                                    ClientEngine.TimeoutHandler timeoutHandler = clientEngine.getTimeoutHandler();
                                    if (timeoutHandler != null) {
                                        timeoutHandler.handleTimeout();
                                    }
                                }
                                catch (DeploymentException e) {
                                    throw e;
                                }
                                catch (Exception e) {
                                    throw new DeploymentException("Handshake response not received.", (Throwable)e);
                                }
                                throw new DeploymentException("Handshake response not received.");
                            }
                            catch (Exception e) {
                                long delay;
                                if (this.reconnectHandler != null && this.reconnectHandler.onConnectFailure(e)) continue;
                                future.setFailure((Throwable)e);
                                return;
                                if ((delay = this.reconnectHandler.getDelay()) <= 0L) continue;
                                ClientManager.this.getScheduledExecutorService().schedule(this, delay, TimeUnit.SECONDS);
                                return;
                            }
                            break;
                        }
                    }
                };
                connector.run();
            }
        });
        return future;
    }

    private int getHandshakeTimeout() {
        Object o = this.properties.get(HANDSHAKE_TIMEOUT);
        if (o != null && o instanceof Integer) {
            return (Integer)o;
        }
        return 30000;
    }

    public int getDefaultMaxBinaryMessageBufferSize() {
        if (this.webSocketContainer == null) {
            return this.maxBinaryMessageBufferSize;
        }
        return this.webSocketContainer.getDefaultMaxBinaryMessageBufferSize();
    }

    public void setDefaultMaxBinaryMessageBufferSize(int i) {
        if (this.webSocketContainer == null) {
            this.maxBinaryMessageBufferSize = i;
        } else {
            this.webSocketContainer.setDefaultMaxBinaryMessageBufferSize(i);
        }
    }

    public int getDefaultMaxTextMessageBufferSize() {
        if (this.webSocketContainer == null) {
            return this.maxTextMessageBufferSize;
        }
        return this.webSocketContainer.getDefaultMaxTextMessageBufferSize();
    }

    public void setDefaultMaxTextMessageBufferSize(int i) {
        if (this.webSocketContainer == null) {
            this.maxTextMessageBufferSize = i;
        } else {
            this.webSocketContainer.setDefaultMaxTextMessageBufferSize(i);
        }
    }

    public Set<Extension> getInstalledExtensions() {
        if (this.webSocketContainer == null) {
            return Collections.emptySet();
        }
        return this.webSocketContainer.getInstalledExtensions();
    }

    public long getDefaultAsyncSendTimeout() {
        if (this.webSocketContainer == null) {
            return this.defaultAsyncSendTimeout;
        }
        return this.webSocketContainer.getDefaultAsyncSendTimeout();
    }

    public void setAsyncSendTimeout(long timeoutmillis) {
        if (this.webSocketContainer == null) {
            this.defaultAsyncSendTimeout = timeoutmillis;
        } else {
            this.webSocketContainer.setAsyncSendTimeout(timeoutmillis);
        }
    }

    public long getDefaultMaxSessionIdleTimeout() {
        if (this.webSocketContainer == null) {
            return this.defaultMaxSessionIdleTimeout;
        }
        return this.webSocketContainer.getDefaultMaxSessionIdleTimeout();
    }

    public void setDefaultMaxSessionIdleTimeout(long defaultMaxSessionIdleTimeout) {
        if (this.webSocketContainer == null) {
            this.defaultMaxSessionIdleTimeout = defaultMaxSessionIdleTimeout;
        } else {
            this.webSocketContainer.setDefaultMaxSessionIdleTimeout(defaultMaxSessionIdleTimeout);
        }
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    private static class RetryAfterReconnectHandler
    extends ReconnectHandler {
        private static final int RETRY_AFTER_THRESHOLD = 5;
        private static final int RETRY_AFTER_MAX_DELAY = 300;
        private final AtomicInteger retryCounter = new AtomicInteger(0);
        private final ReconnectHandler userReconnectHandler;
        private long delay = 0L;

        RetryAfterReconnectHandler(ReconnectHandler userReconnectHandler) {
            this.userReconnectHandler = userReconnectHandler;
        }

        @Override
        public boolean onDisconnect(CloseReason closeReason) {
            return this.userReconnectHandler != null && this.userReconnectHandler.onDisconnect(closeReason);
        }

        @Override
        public boolean onConnectFailure(Exception exception) {
            RetryAfterException retryAfterException;
            Throwable t = exception;
            if (t instanceof DeploymentException && (t = t.getCause()) != null && t instanceof RetryAfterException && (retryAfterException = (RetryAfterException)((Object)t)).getDelay() != null && this.retryCounter.getAndIncrement() < 5 && retryAfterException.getDelay() <= 300L) {
                this.delay = retryAfterException.getDelay() < 0L ? 0L : retryAfterException.getDelay();
                return true;
            }
            return this.userReconnectHandler != null && this.userReconnectHandler.onConnectFailure(exception);
        }

        @Override
        public long getDelay() {
            return this.delay;
        }
    }

    public static class ReconnectHandler {
        private static final long RECONNECT_DELAY = 5L;

        public boolean onDisconnect(CloseReason closeReason) {
            return false;
        }

        public boolean onConnectFailure(Exception exception) {
            return false;
        }

        public long getDelay() {
            return 5L;
        }
    }

    private static class SameThreadExecutorService
    extends AbstractExecutorService {
        private SameThreadExecutorService() {
        }

        @Override
        public void shutdown() {
        }

        @Override
        public List<Runnable> shutdownNow() {
            return Collections.emptyList();
        }

        @Override
        public boolean isShutdown() {
            return false;
        }

        @Override
        public boolean isTerminated() {
            return false;
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return false;
        }

        @Override
        public void execute(Runnable command) {
            command.run();
        }
    }

    private static interface ClientManagerHandshakeListener
    extends TyrusClientEngine.ClientHandshakeListener {
        public Session getSession();

        public Throwable getThrowable();
    }
}

