/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.client;

import jakarta.websocket.ClientEndpointConfig;
import jakarta.websocket.CloseReason;
import jakarta.websocket.Extension;
import jakarta.websocket.HandshakeResponse;
import jakarta.websocket.Session;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.tyrus.client.RedirectException;
import org.glassfish.tyrus.client.RetryAfterException;
import org.glassfish.tyrus.client.auth.AuthConfig;
import org.glassfish.tyrus.client.auth.AuthenticationException;
import org.glassfish.tyrus.client.auth.Authenticator;
import org.glassfish.tyrus.client.auth.Credentials;
import org.glassfish.tyrus.core.DebugContext;
import org.glassfish.tyrus.core.Handshake;
import org.glassfish.tyrus.core.HandshakeException;
import org.glassfish.tyrus.core.MaskingKeyGenerator;
import org.glassfish.tyrus.core.ProtocolHandler;
import org.glassfish.tyrus.core.RequestContext;
import org.glassfish.tyrus.core.TyrusEndpointWrapper;
import org.glassfish.tyrus.core.TyrusExtension;
import org.glassfish.tyrus.core.TyrusWebSocket;
import org.glassfish.tyrus.core.Utils;
import org.glassfish.tyrus.core.Version;
import org.glassfish.tyrus.core.WebSocketException;
import org.glassfish.tyrus.core.extension.ExtendedExtension;
import org.glassfish.tyrus.core.frame.CloseFrame;
import org.glassfish.tyrus.core.frame.Frame;
import org.glassfish.tyrus.core.l10n.LocalizationMessages;
import org.glassfish.tyrus.spi.ClientEngine;
import org.glassfish.tyrus.spi.Connection;
import org.glassfish.tyrus.spi.ReadHandler;
import org.glassfish.tyrus.spi.UpgradeRequest;
import org.glassfish.tyrus.spi.UpgradeResponse;
import org.glassfish.tyrus.spi.Writer;

public class TyrusClientEngine
implements ClientEngine {
    public static final int DEFAULT_INCOMING_BUFFER_SIZE = 0x40000B;
    private static final Logger LOGGER = Logger.getLogger(TyrusClientEngine.class.getName());
    private static final Version DEFAULT_VERSION = Version.DRAFT17;
    private static final int BUFFER_STEP_SIZE = 256;
    private static final int DEFAULT_REDIRECT_THRESHOLD = 5;
    private final ProtocolHandler protocolHandler;
    private final TyrusEndpointWrapper endpointWrapper;
    private final ClientHandshakeListener listener;
    private final Map<String, Object> properties;
    private final URI connectToServerUriParam;
    private final Boolean redirectEnabled;
    private final int redirectThreshold;
    private final DebugContext debugContext;
    private final boolean logUpgradeMessages;
    private volatile Handshake clientHandShake = null;
    private volatile ClientEngine.TimeoutHandler timeoutHandler = null;
    private volatile TyrusClientEngineState clientEngineState = TyrusClientEngineState.INIT;
    private volatile URI redirectLocation = null;
    private final Set<URI> redirectUriHistory;
    private static final ClientEngine.ClientUpgradeInfo UPGRADE_INFO_FAILED = new ClientEngine.ClientUpgradeInfo(){

        public ClientEngine.ClientUpgradeStatus getUpgradeStatus() {
            return ClientEngine.ClientUpgradeStatus.UPGRADE_REQUEST_FAILED;
        }

        public Connection createConnection() {
            return null;
        }
    };
    private static final ClientEngine.ClientUpgradeInfo UPGRADE_INFO_ANOTHER_REQUEST_REQUIRED = new ClientEngine.ClientUpgradeInfo(){

        public ClientEngine.ClientUpgradeStatus getUpgradeStatus() {
            return ClientEngine.ClientUpgradeStatus.ANOTHER_UPGRADE_REQUEST_REQUIRED;
        }

        public Connection createConnection() {
            return null;
        }
    };

    TyrusClientEngine(TyrusEndpointWrapper endpointWrapper, ClientHandshakeListener listener, Map<String, Object> properties, URI connectToServerUriParam, DebugContext debugContext) {
        this.endpointWrapper = endpointWrapper;
        this.listener = listener;
        this.properties = properties;
        this.connectToServerUriParam = connectToServerUriParam;
        MaskingKeyGenerator maskingKeyGenerator = (MaskingKeyGenerator)Utils.getProperty(properties, (String)"org.glassfish.tyrus.client.maskingKeyGenerator", MaskingKeyGenerator.class, null);
        this.protocolHandler = DEFAULT_VERSION.createHandler(true, maskingKeyGenerator);
        this.redirectUriHistory = Collections.synchronizedSet(new HashSet(5));
        this.redirectEnabled = (Boolean)Utils.getProperty(properties, (String)"org.glassfish.tyrus.client.http.redirect", Boolean.class, (Object)false);
        Integer redirectThreshold = (Integer)Utils.getProperty(properties, (String)"org.glassfish.tyrus.client.http.redirect.threshold", Integer.class, (Object)5);
        if (redirectThreshold == null) {
            redirectThreshold = 5;
        }
        this.redirectThreshold = redirectThreshold;
        this.debugContext = debugContext;
        this.logUpgradeMessages = (Boolean)Utils.getProperty(properties, (String)"org.glassfish.tyrus.client.http.logUpgrade", Boolean.class, (Object)false);
        debugContext.appendLogMessage(LOGGER, Level.FINE, DebugContext.Type.OTHER, new Object[]{"Redirect enabled: ", this.redirectEnabled});
        if (this.redirectEnabled.booleanValue()) {
            debugContext.appendLogMessage(LOGGER, Level.FINE, DebugContext.Type.OTHER, new Object[]{"Redirect threshold: ", redirectThreshold});
        }
    }

    public UpgradeRequest createUpgradeRequest(ClientEngine.TimeoutHandler timeoutHandler) {
        switch (this.clientEngineState) {
            case INIT: {
                ClientEndpointConfig config = (ClientEndpointConfig)this.endpointWrapper.getEndpointConfig();
                this.timeoutHandler = timeoutHandler;
                this.clientHandShake = Handshake.createClientHandshake((RequestContext)RequestContext.Builder.create().requestURI(this.connectToServerUriParam).secure("wss".equals(this.connectToServerUriParam.getScheme())).build());
                this.clientHandShake.setExtensions(config.getExtensions());
                this.clientHandShake.setSubProtocols(config.getPreferredSubprotocols());
                this.clientHandShake.prepareRequest();
                RequestContext upgradeRequest = this.clientHandShake.getRequest();
                config.getConfigurator().beforeRequest(upgradeRequest.getHeaders());
                this.clientEngineState = TyrusClientEngineState.UPGRADE_REQUEST_CREATED;
                this.logUpgradeRequest((UpgradeRequest)upgradeRequest);
                return upgradeRequest;
            }
            case REDIRECT_REQUIRED: {
                this.timeoutHandler = timeoutHandler;
                URI requestUri = this.redirectLocation;
                RequestContext requestContext = RequestContext.Builder.create((RequestContext)this.clientHandShake.getRequest()).requestURI(requestUri).secure("wss".equalsIgnoreCase(requestUri.getScheme())).build();
                Handshake.updateHostAndOrigin((UpgradeRequest)requestContext);
                this.clientEngineState = TyrusClientEngineState.UPGRADE_REQUEST_CREATED;
                this.logUpgradeRequest((UpgradeRequest)requestContext);
                return requestContext;
            }
            case AUTH_REQUIRED: {
                RequestContext upgradeRequest = this.clientHandShake.getRequest();
                if (this.clientEngineState.getAuthenticator() != null) {
                    String authorizationHeader;
                    if (LOGGER.isLoggable(Level.CONFIG)) {
                        this.debugContext.appendLogMessage(LOGGER, Level.CONFIG, DebugContext.Type.MESSAGE_OUT, new Object[]{"Using authenticator: ", this.clientEngineState.getAuthenticator().getClass().getName()});
                    }
                    try {
                        Credentials credentials = (Credentials)this.properties.get("org.glassfish.tyrus.client.http.auth.Credentials");
                        this.debugContext.appendLogMessage(LOGGER, Level.CONFIG, DebugContext.Type.MESSAGE_OUT, new Object[]{"Using credentials: ", credentials});
                        authorizationHeader = this.clientEngineState.getAuthenticator().generateAuthorizationHeader(upgradeRequest.getRequestURI(), this.clientEngineState.getWwwAuthenticateHeader(), credentials);
                    }
                    catch (AuthenticationException e) {
                        this.listener.onError((Throwable)((Object)e));
                        return null;
                    }
                    upgradeRequest.getHeaders().put("Authorization", Collections.singletonList(authorizationHeader));
                }
                this.clientEngineState = TyrusClientEngineState.AUTH_UPGRADE_REQUEST_CREATED;
                this.logUpgradeRequest((UpgradeRequest)upgradeRequest);
                return upgradeRequest;
            }
        }
        this.redirectUriHistory.clear();
        throw new IllegalStateException();
    }

    /*
     * Unable to fully structure code
     */
    public ClientEngine.ClientUpgradeInfo processResponse(UpgradeResponse upgradeResponse, Writer writer, Connection.CloseListener closeListener) {
        block15: {
            if (TyrusClientEngine.LOGGER.isLoggable(Level.FINE)) {
                this.debugContext.appendLogMessage(TyrusClientEngine.LOGGER, Level.FINE, DebugContext.Type.MESSAGE_IN, new Object[]{"Received handshake response: \n" + Utils.stringifyUpgradeResponse((UpgradeResponse)upgradeResponse)});
            } else if (this.logUpgradeMessages) {
                this.debugContext.appendStandardOutputMessage(DebugContext.Type.MESSAGE_IN, "Received handshake response: \n" + Utils.stringifyUpgradeResponse((UpgradeResponse)upgradeResponse));
            }
            if (this.clientEngineState != TyrusClientEngineState.AUTH_UPGRADE_REQUEST_CREATED && this.clientEngineState != TyrusClientEngineState.UPGRADE_REQUEST_CREATED) break block15;
            if (upgradeResponse == null) {
                throw new IllegalArgumentException(LocalizationMessages.ARGUMENT_NOT_NULL((Object)"upgradeResponse"));
            }
            switch (upgradeResponse.getStatus()) {
                case 101: {
                    return this.handleSwitchProtocol(upgradeResponse, writer, closeListener);
                }
                case 300: 
                case 301: 
                case 302: 
                case 303: 
                case 307: 
                case 308: {
                    return this.handleRedirect(upgradeResponse);
                }
                case 401: {
                    return this.handleAuth(upgradeResponse);
                }
                case 503: {
                    retryAfterString = null;
                    retryAfterHeader = (List)upgradeResponse.getHeaders().get("Retry-After");
                    if (retryAfterHeader != null) {
                        retryAfterString = Utils.getHeaderFromList((List)retryAfterHeader);
                    }
                    if (retryAfterString == null) ** GOTO lbl33
                    try {
                        date = Utils.parseHttpDate((String)retryAfterString);
                        delay = (date.getTime() - System.currentTimeMillis()) / 1000L;
                    }
                    catch (ParseException e) {
                        try {
                            delay = Long.parseLong(retryAfterString);
                            ** GOTO lbl34
                        }
                        catch (NumberFormatException iae) {
                            delay = null;
                        }
                    }
                    ** GOTO lbl34
lbl33:
                    // 1 sources

                    delay = null;
lbl34:
                    // 4 sources

                    this.listener.onError((Throwable)new RetryAfterException(LocalizationMessages.HANDSHAKE_HTTP_RETRY_AFTER_MESSAGE(), delay));
                    return TyrusClientEngine.UPGRADE_INFO_FAILED;
                }
            }
            this.clientEngineState = TyrusClientEngineState.FAILED;
            e = new HandshakeException(upgradeResponse.getStatus(), LocalizationMessages.INVALID_RESPONSE_CODE((Object)101, (Object)upgradeResponse.getStatus()));
            this.listener.onError((Throwable)e);
            this.redirectUriHistory.clear();
            return TyrusClientEngine.UPGRADE_INFO_FAILED;
        }
        this.redirectUriHistory.clear();
        throw new IllegalStateException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClientEngine.ClientUpgradeInfo handleSwitchProtocol(UpgradeResponse upgradeResponse, Writer writer, Connection.CloseListener closeListener) {
        this.clientEngineState = TyrusClientEngineState.SUCCESS;
        try {
            ClientEngine.ClientUpgradeInfo clientUpgradeInfo = this.processUpgradeResponse(upgradeResponse, writer, closeListener);
            return clientUpgradeInfo;
        }
        catch (HandshakeException e) {
            this.clientEngineState = TyrusClientEngineState.FAILED;
            this.listener.onError(e);
            ClientEngine.ClientUpgradeInfo clientUpgradeInfo = UPGRADE_INFO_FAILED;
            return clientUpgradeInfo;
        }
        finally {
            this.redirectUriHistory.clear();
        }
    }

    private ClientEngine.ClientUpgradeInfo handleAuth(UpgradeResponse upgradeResponse) {
        if (this.clientEngineState == TyrusClientEngineState.AUTH_UPGRADE_REQUEST_CREATED) {
            this.clientEngineState = TyrusClientEngineState.FAILED;
            this.listener.onError((Throwable)((Object)new AuthenticationException(LocalizationMessages.AUTHENTICATION_FAILED())));
            return UPGRADE_INFO_FAILED;
        }
        AuthConfig authConfig = (AuthConfig)Utils.getProperty(this.properties, (String)"org.glassfish.tyrus.client.http.auth.AuthConfig", AuthConfig.class, (Object)AuthConfig.Builder.create().build());
        this.debugContext.appendLogMessage(LOGGER, Level.FINE, DebugContext.Type.MESSAGE_OUT, new Object[]{"Using authentication config: ", authConfig});
        if (authConfig == null) {
            this.clientEngineState = TyrusClientEngineState.FAILED;
            this.listener.onError((Throwable)((Object)new AuthenticationException(LocalizationMessages.AUTHENTICATION_FAILED())));
            return UPGRADE_INFO_FAILED;
        }
        String wwwAuthenticateHeader = null;
        List authHeader = (List)upgradeResponse.getHeaders().get("WWW-Authenticate");
        if (authHeader != null) {
            wwwAuthenticateHeader = Utils.getHeaderFromList((List)authHeader);
        }
        if (wwwAuthenticateHeader == null || wwwAuthenticateHeader.equals("")) {
            this.clientEngineState = TyrusClientEngineState.FAILED;
            this.listener.onError((Throwable)((Object)new AuthenticationException(LocalizationMessages.AUTHENTICATION_FAILED())));
            return UPGRADE_INFO_FAILED;
        }
        String[] tokens = wwwAuthenticateHeader.trim().split("\\s+", 2);
        String scheme = tokens[0];
        this.debugContext.appendLogMessage(LOGGER, Level.FINE, DebugContext.Type.MESSAGE_OUT, new Object[]{"Using authentication scheme: ", scheme});
        Authenticator authenticator = authConfig.getAuthenticators().get(scheme);
        if (authenticator == null) {
            this.clientEngineState = TyrusClientEngineState.FAILED;
            this.listener.onError((Throwable)((Object)new AuthenticationException(LocalizationMessages.AUTHENTICATION_FAILED())));
            return UPGRADE_INFO_FAILED;
        }
        this.clientEngineState = TyrusClientEngineState.AUTH_REQUIRED;
        this.clientEngineState.setAuthenticator(authenticator);
        this.clientEngineState.setWwwAuthenticateHeader(wwwAuthenticateHeader);
        return UPGRADE_INFO_ANOTHER_REQUEST_REQUIRED;
    }

    private ClientEngine.ClientUpgradeInfo handleRedirect(UpgradeResponse upgradeResponse) {
        boolean alreadyRequested;
        URI location;
        if (!this.redirectEnabled.booleanValue()) {
            this.clientEngineState = TyrusClientEngineState.FAILED;
            this.listener.onError((Throwable)((Object)new RedirectException(upgradeResponse.getStatus(), LocalizationMessages.HANDSHAKE_HTTP_REDIRECTION_NOT_ENABLED((Object)upgradeResponse.getStatus()))));
            return UPGRADE_INFO_FAILED;
        }
        String locationString = null;
        List locationHeader = (List)upgradeResponse.getHeaders().get("Location");
        if (locationHeader != null) {
            locationString = Utils.getHeaderFromList((List)locationHeader);
        }
        if (locationString == null || locationString.equals("")) {
            this.listener.onError((Throwable)((Object)new RedirectException(upgradeResponse.getStatus(), LocalizationMessages.HANDSHAKE_HTTP_REDIRECTION_NEW_LOCATION_MISSING())));
            this.clientEngineState = TyrusClientEngineState.FAILED;
            return UPGRADE_INFO_FAILED;
        }
        try {
            location = new URI(locationString);
            String scheme = location.getScheme();
            if ("http".equalsIgnoreCase(scheme)) {
                scheme = "ws";
            }
            if ("https".equalsIgnoreCase(scheme)) {
                scheme = "wss";
            }
            int port = Utils.getWsPort((URI)location, (String)scheme);
            if (!(location = new URI(scheme, location.getUserInfo(), location.getHost(), port, location.getPath(), location.getQuery(), location.getFragment())).isAbsolute()) {
                URI baseUri = this.redirectLocation == null ? this.connectToServerUriParam : this.redirectLocation;
                location = baseUri.resolve(location.normalize());
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finest("HTTP Redirect - Base URI for resolving target location: " + baseUri);
                    LOGGER.finest("HTTP Redirect - Location URI header: " + locationString);
                    LOGGER.finest("HTTP Redirect - Normalized and resolved Location URI header against base URI: " + location);
                }
            }
        }
        catch (URISyntaxException e) {
            this.clientEngineState = TyrusClientEngineState.FAILED;
            this.listener.onError((Throwable)((Object)new RedirectException(upgradeResponse.getStatus(), LocalizationMessages.HANDSHAKE_HTTP_REDIRECTION_NEW_LOCATION_ERROR((Object)locationString))));
            return UPGRADE_INFO_FAILED;
        }
        boolean bl = alreadyRequested = !this.redirectUriHistory.add(location);
        if (alreadyRequested) {
            this.clientEngineState = TyrusClientEngineState.FAILED;
            this.listener.onError((Throwable)((Object)new RedirectException(upgradeResponse.getStatus(), LocalizationMessages.HANDSHAKE_HTTP_REDIRECTION_INFINITE_LOOP())));
            return UPGRADE_INFO_FAILED;
        }
        if (this.redirectUriHistory.size() > this.redirectThreshold) {
            this.clientEngineState = TyrusClientEngineState.FAILED;
            this.listener.onError((Throwable)((Object)new RedirectException(upgradeResponse.getStatus(), LocalizationMessages.HANDSHAKE_HTTP_REDIRECTION_MAX_REDIRECTION((Object)this.redirectThreshold))));
            return UPGRADE_INFO_FAILED;
        }
        this.clientEngineState = TyrusClientEngineState.REDIRECT_REQUIRED;
        this.redirectLocation = location;
        return UPGRADE_INFO_ANOTHER_REQUEST_REQUIRED;
    }

    public void processError(Throwable t) {
        if (this.clientEngineState == TyrusClientEngineState.SUCCESS) {
            throw new IllegalStateException();
        }
        if (this.clientEngineState != TyrusClientEngineState.FAILED) {
            this.clientEngineState = TyrusClientEngineState.FAILED;
            this.listener.onError(t);
        }
    }

    private void logUpgradeRequest(UpgradeRequest upgradeRequest) {
        if (LOGGER.isLoggable(Level.FINE)) {
            this.debugContext.appendLogMessage(LOGGER, Level.FINE, DebugContext.Type.MESSAGE_OUT, new Object[]{"Sending handshake request:\n" + Utils.stringifyUpgradeRequest((UpgradeRequest)upgradeRequest)});
        } else if (this.logUpgradeMessages) {
            this.debugContext.appendStandardOutputMessage(DebugContext.Type.MESSAGE_OUT, "Sending handshake request:\n" + Utils.stringifyUpgradeRequest((UpgradeRequest)upgradeRequest));
        }
    }

    private ClientEngine.ClientUpgradeInfo processUpgradeResponse(UpgradeResponse upgradeResponse, final Writer writer, final Connection.CloseListener closeListener) throws HandshakeException {
        this.clientHandShake.validateServerResponse(upgradeResponse);
        final TyrusWebSocket socket = new TyrusWebSocket(this.protocolHandler, this.endpointWrapper);
        List handshakeResponseExtensions = TyrusExtension.fromHeaders((List)((List)upgradeResponse.getHeaders().get("Sec-WebSocket-Extensions")));
        ArrayList<Extension> extensions = new ArrayList<Extension>();
        final ExtendedExtension.ExtensionContext extensionContext = new ExtendedExtension.ExtensionContext(){
            private final Map<String, Object> properties = new HashMap<String, Object>();

            public Map<String, Object> getProperties() {
                return this.properties;
            }
        };
        for (Extension responseExtension : handshakeResponseExtensions) {
            for (Extension installedExtension : ((ClientEndpointConfig)this.endpointWrapper.getEndpointConfig()).getExtensions()) {
                String responseExtensionName = responseExtension.getName();
                if (responseExtensionName == null || !responseExtensionName.equals(installedExtension.getName())) continue;
                boolean alreadyAdded = false;
                for (Extension extension : extensions) {
                    if (!extension.getName().equals(responseExtensionName)) continue;
                    alreadyAdded = true;
                }
                if (alreadyAdded) continue;
                if (installedExtension instanceof ExtendedExtension) {
                    ((ExtendedExtension)installedExtension).onHandshakeResponse(extensionContext, responseExtension.getParameters());
                }
                extensions.add(installedExtension);
                this.debugContext.appendLogMessage(LOGGER, Level.FINE, DebugContext.Type.OTHER, new Object[]{"Installed extension: ", installedExtension.getName()});
            }
        }
        final Session sessionForRemoteEndpoint = this.endpointWrapper.createSessionForRemoteEndpoint(socket, upgradeResponse.getFirstHeaderValue("Sec-WebSocket-Protocol"), extensions, this.debugContext);
        ((ClientEndpointConfig)this.endpointWrapper.getEndpointConfig()).getConfigurator().afterResponse((HandshakeResponse)upgradeResponse);
        this.protocolHandler.setWriter(writer);
        this.protocolHandler.setWebSocket(socket);
        this.protocolHandler.setExtensions(extensions);
        this.protocolHandler.setExtensionContext(extensionContext);
        socket.onConnect((UpgradeRequest)this.clientHandShake.getRequest(), null, null, null, this.debugContext);
        this.listener.onSessionCreated(sessionForRemoteEndpoint);
        Integer tyrusIncomingBufferSize = (Integer)Utils.getProperty(this.properties, (String)"org.glassfish.tyrus.incomingBufferSize", Integer.class);
        Integer wlsIncomingBufferSize = (Integer)Utils.getProperty((Map)this.endpointWrapper.getEndpointConfig().getUserProperties(), (String)"weblogic.websocket.tyrus.incoming-buffer-size", Integer.class);
        final Integer incomingBufferSize = tyrusIncomingBufferSize == null && wlsIncomingBufferSize == null ? Integer.valueOf(0x40000B) : (wlsIncomingBufferSize != null ? wlsIncomingBufferSize : tyrusIncomingBufferSize);
        this.debugContext.appendLogMessage(LOGGER, Level.FINE, DebugContext.Type.OTHER, new Object[]{"Incoming buffer size: ", incomingBufferSize});
        return new ClientEngine.ClientUpgradeInfo(){

            public ClientEngine.ClientUpgradeStatus getUpgradeStatus() {
                return ClientEngine.ClientUpgradeStatus.SUCCESS;
            }

            public Connection createConnection() {
                return new Connection(){
                    private final ReadHandler readHandler;
                    {
                        this.readHandler = new TyrusReadHandler(TyrusClientEngine.this.protocolHandler, socket, incomingBufferSize, sessionForRemoteEndpoint.getNegotiatedExtensions(), extensionContext);
                    }

                    public ReadHandler getReadHandler() {
                        return this.readHandler;
                    }

                    public Writer getWriter() {
                        return writer;
                    }

                    public Connection.CloseListener getCloseListener() {
                        return closeListener;
                    }

                    public void close(CloseReason reason) {
                        try {
                            writer.close();
                        }
                        catch (IOException e) {
                            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getMessage(), e);
                        }
                        socket.close(reason.getCloseCode().getCode(), reason.getReasonPhrase());
                        for (Extension extension : sessionForRemoteEndpoint.getNegotiatedExtensions()) {
                            if (!(extension instanceof ExtendedExtension)) continue;
                            ((ExtendedExtension)extension).destroy(extensionContext);
                        }
                    }
                };
            }
        };
    }

    public ClientEngine.TimeoutHandler getTimeoutHandler() {
        return this.timeoutHandler;
    }

    private static enum TyrusClientEngineState {
        INIT,
        REDIRECT_REQUIRED,
        AUTH_REQUIRED,
        AUTH_UPGRADE_REQUEST_CREATED,
        UPGRADE_REQUEST_CREATED,
        FAILED,
        SUCCESS;

        private volatile Authenticator authenticator;
        private volatile String wwwAuthenticateHeader;

        Authenticator getAuthenticator() {
            return this.authenticator;
        }

        void setAuthenticator(Authenticator authenticator) {
            this.authenticator = authenticator;
        }

        String getWwwAuthenticateHeader() {
            return this.wwwAuthenticateHeader;
        }

        void setWwwAuthenticateHeader(String wwwAuthenticateHeader) {
            this.wwwAuthenticateHeader = wwwAuthenticateHeader;
        }
    }

    private static class TyrusReadHandler
    implements ReadHandler {
        private final int incomingBufferSize;
        private final ProtocolHandler handler;
        private final TyrusWebSocket socket;
        private final List<Extension> negotiatedExtensions;
        private final ExtendedExtension.ExtensionContext extensionContext;
        private ByteBuffer buffer = null;

        TyrusReadHandler(ProtocolHandler protocolHandler, TyrusWebSocket socket, int incomingBufferSize, List<Extension> negotiatedExtensions, ExtendedExtension.ExtensionContext extensionContext) {
            this.handler = protocolHandler;
            this.socket = socket;
            this.incomingBufferSize = incomingBufferSize;
            this.negotiatedExtensions = negotiatedExtensions;
            this.extensionContext = extensionContext;
            protocolHandler.setExtensionContext(extensionContext);
        }

        public void handle(ByteBuffer data) {
            block11: {
                try {
                    if (data == null || !data.hasRemaining()) break block11;
                    if (this.buffer != null) {
                        data = Utils.appendBuffers((ByteBuffer)this.buffer, (ByteBuffer)data, (int)this.incomingBufferSize, (int)256);
                    } else {
                        int newSize = data.remaining();
                        if (newSize > this.incomingBufferSize) {
                            throw new IllegalArgumentException("Buffer overflow.");
                        }
                        int roundedSize = newSize % 256 > 0 ? (newSize / 256 + 1) * 256 : newSize;
                        ByteBuffer result = ByteBuffer.allocate(roundedSize > this.incomingBufferSize ? newSize : roundedSize);
                        result.flip();
                        data = Utils.appendBuffers((ByteBuffer)result, (ByteBuffer)data, (int)this.incomingBufferSize, (int)256);
                    }
                    while (true) {
                        Frame frame;
                        if ((frame = this.handler.unframe(data)) == null) {
                            this.buffer = data;
                            break;
                        }
                        for (Extension extension : this.negotiatedExtensions) {
                            if (!(extension instanceof ExtendedExtension)) continue;
                            try {
                                frame = ((ExtendedExtension)extension).processIncoming(this.extensionContext, frame);
                            }
                            catch (Throwable t) {
                                LOGGER.log(Level.FINE, String.format("Extension '%s' threw an exception during processIncoming method invocation: \"%s\".", extension.getName(), t.getMessage()), t);
                            }
                        }
                        this.handler.process(frame, this.socket);
                    }
                }
                catch (WebSocketException e) {
                    LOGGER.log(Level.FINE, e.getMessage(), e);
                    this.socket.onClose(new CloseFrame(e.getCloseReason()));
                }
                catch (Exception e) {
                    LOGGER.log(Level.FINE, e.getMessage(), e);
                    this.socket.onClose(new CloseFrame(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.UNEXPECTED_CONDITION, e.getMessage())));
                }
            }
        }
    }

    public static interface ClientHandshakeListener {
        public void onSessionCreated(Session var1);

        public void onError(Throwable var1);
    }
}

