/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.gf.cdi;

import java.util.logging.Logger;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.glassfish.tyrus.spi.ComponentProvider;

public class CdiComponentProvider
extends ComponentProvider {
    private final BeanManager beanManager;
    private static final Logger LOGGER = Logger.getLogger(CdiComponentProvider.class.getName());
    private final boolean managerRetrieved;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CdiComponentProvider() throws NamingException {
        InitialContext ic = new InitialContext();
        BeanManager manager = null;
        try {
            this.beanManager = manager = (BeanManager)ic.lookup("java:comp/BeanManager");
            this.managerRetrieved = this.beanManager != null;
        }
        catch (Exception e) {
            try {
                LOGGER.fine(e.getMessage());
                this.beanManager = manager;
                this.managerRetrieved = this.beanManager != null;
            }
            catch (Throwable throwable) {
                this.beanManager = manager;
                this.managerRetrieved = this.beanManager != null;
                throw throwable;
            }
        }
    }

    public boolean isApplicable(Class<?> c) {
        return this.managerRetrieved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T provideInstance(Class<T> c) {
        if (this.managerRetrieved) {
            CreationalContext cc;
            InjectionTarget it;
            BeanManager beanManager = this.beanManager;
            synchronized (beanManager) {
                AnnotatedType annotatedType = this.beanManager.createAnnotatedType(c);
                it = this.beanManager.createInjectionTarget(annotatedType);
                cc = this.beanManager.createCreationalContext(null);
            }
            Object managedObject = it.produce(cc);
            it.inject(managedObject, cc);
            it.postConstruct(managedObject);
            return (T)managedObject;
        }
        return null;
    }
}

