/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.gf.cdi;

import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.glassfish.tyrus.spi.ComponentProvider;

public class CdiComponentProvider
extends ComponentProvider {
    private final BeanManager beanManager;
    private static final Logger LOGGER = Logger.getLogger(CdiComponentProvider.class.getName());
    private final boolean managerRetrieved;
    private final Map<Object, CdiInjectionContext> cdiBeanToContext = new ConcurrentHashMap<Object, CdiInjectionContext>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CdiComponentProvider() throws NamingException {
        InitialContext ic = new InitialContext();
        BeanManager manager = null;
        try {
            this.beanManager = manager = (BeanManager)ic.lookup("java:comp/BeanManager");
            this.managerRetrieved = this.beanManager != null;
        }
        catch (Exception e) {
            try {
                LOGGER.fine(e.getMessage());
                this.beanManager = manager;
                this.managerRetrieved = this.beanManager != null;
            }
            catch (Throwable throwable) {
                this.beanManager = manager;
                this.managerRetrieved = this.beanManager != null;
                throw throwable;
            }
        }
    }

    public boolean isApplicable(Class<?> c) {
        Annotation[] annotations;
        for (Annotation annotation : annotations = c.getAnnotations()) {
            String annotationClassName = annotation.annotationType().getCanonicalName();
            if (!annotationClassName.equals("javax.ejb.Singleton") && !annotationClassName.equals("javax.ejb.Stateful") && !annotationClassName.equals("javax.ejb.Stateless")) continue;
            return false;
        }
        return this.managerRetrieved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T provideInstance(Class<T> c) {
        if (this.managerRetrieved) {
            BeanManager beanManager = this.beanManager;
            synchronized (beanManager) {
                Object managedObject = null;
                AnnotatedType annotatedType = this.beanManager.createAnnotatedType(c);
                InjectionTarget it = this.beanManager.createInjectionTarget(annotatedType);
                CreationalContext cc = this.beanManager.createCreationalContext(null);
                managedObject = it.produce(cc);
                it.inject(managedObject, cc);
                it.postConstruct(managedObject);
                this.cdiBeanToContext.put(managedObject, new CdiInjectionContext(it, cc));
                return (T)managedObject;
            }
        }
        return null;
    }

    public boolean destroyInstance(Object o) {
        if (this.cdiBeanToContext.containsKey(o)) {
            this.cdiBeanToContext.get(o).cleanup(o);
            this.cdiBeanToContext.remove(o);
            return true;
        }
        return false;
    }

    private static class CdiInjectionContext {
        InjectionTarget it;
        CreationalContext cc;

        CdiInjectionContext(InjectionTarget it, CreationalContext cc) {
            this.it = it;
            this.cc = cc;
        }

        public void cleanup(Object instance) {
            this.it.preDestroy(instance);
            this.it.dispose(instance);
            this.cc.release();
        }
    }
}

